/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.data;

import adams.data.spreadsheet.SpreadSheet;
import java.util.Arrays;
import java.util.HashSet;

public class Dataset
extends SpreadSheet {
    private static final long serialVersionUID = -6517147329804452995L;
    protected HashSet<String> m_ClassAttributes;

    public Dataset() {
    }

    public Dataset(SpreadSheet sheet) {
        this();
        this.assign(sheet);
    }

    protected void initialize() {
        super.initialize();
        this.m_ClassAttributes = new HashSet();
    }

    public void clear() {
        super.clear();
        this.m_ClassAttributes.clear();
    }

    public void assign(SpreadSheet sheet) {
        super.assign(sheet);
        if (sheet instanceof Dataset) {
            this.m_ClassAttributes.addAll(((Dataset)sheet).m_ClassAttributes);
        }
    }

    public Dataset newInstance() {
        Dataset result = new Dataset();
        result.setDataRowClass(this.getDataRowClass());
        return result;
    }

    public SpreadSheet getClone() {
        SpreadSheet result = super.getClone();
        if (result instanceof Dataset) {
            ((Dataset)result).m_ClassAttributes.addAll(this.m_ClassAttributes);
        }
        return result;
    }

    public SpreadSheet getHeader() {
        SpreadSheet result = super.getHeader();
        if (result instanceof Dataset) {
            ((Dataset)result).m_ClassAttributes.addAll(this.m_ClassAttributes);
        }
        return result;
    }

    public boolean removeColumn(String columnKey) {
        this.m_ClassAttributes.remove(columnKey);
        return super.removeColumn(columnKey);
    }

    public boolean isClassAttribute(String colKey) {
        if (colKey == null) {
            return false;
        }
        return this.m_ClassAttributes.contains(colKey);
    }

    public boolean isClassAttribute(int colIndex) {
        return this.isClassAttribute(this.m_HeaderRow.getCellKey(colIndex));
    }

    public boolean setClassAttribute(String colKey, boolean isClass) {
        if (colKey == null) {
            return false;
        }
        if (this.getHeaderRow().indexOf(colKey) == -1) {
            return false;
        }
        if (isClass) {
            this.m_ClassAttributes.add(colKey);
        } else {
            this.m_ClassAttributes.remove(colKey);
        }
        return true;
    }

    public boolean setClassAttribute(int colIndex, boolean isClass) {
        return this.setClassAttribute(this.m_HeaderRow.getCellKey(colIndex), isClass);
    }

    public String[] getClassAttributeKeys() {
        return this.m_ClassAttributes.toArray(new String[this.m_ClassAttributes.size()]);
    }

    public int[] getClassAttributeIndices() {
        String[] keys = this.getClassAttributeKeys();
        int[] result = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            result[i] = this.getHeaderRow().indexOf(keys[i]);
        }
        Arrays.sort(result);
        return result;
    }

    public String equalsHeader(SpreadSheet other) {
        String result = super.equalsHeader(other);
        if (result == null && other instanceof Dataset) {
            int[] otherIndices;
            int[] indices = this.getClassAttributeIndices();
            if (indices.length != (otherIndices = ((Dataset)other).getClassAttributeIndices()).length) {
                result = "Number of class attributes differ: " + indices.length + " != " + otherIndices.length;
            }
            if (result == null) {
                for (int i = 0; i < indices.length; ++i) {
                    if (indices[i] == otherIndices[i]) continue;
                    result = "Class attribute index #" + (i + 1) + " differs: " + (indices[i] + 1) + " != " + (otherIndices[i] + 1);
                    break;
                }
            }
        }
        return result;
    }

    public void mergeWith(SpreadSheet other) {
        int numCols = this.getColumnCount();
        super.mergeWith(other);
        if (other instanceof Dataset) {
            int[] indices = ((Dataset)other).getClassAttributeIndices();
            for (int i = 0; i < indices.length; ++i) {
                this.setClassAttribute(numCols + indices[i], true);
            }
        }
    }
}

