/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.Variables;
import adams.core.logging.LoggingLevel;
import adams.core.option.OptionHandler;
import adams.flow.control.Sequence;
import adams.flow.control.StorageName;
import adams.flow.control.StorageQueueHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.DaemonEvent;
import adams.flow.core.EventRunnable;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.Token;
import adams.flow.standalone.AbstractStandalone;
import java.util.logging.Level;

public class QueueEvent
extends AbstractStandalone
implements MutableActorHandler,
DaemonEvent {
    private static final long serialVersionUID = 4670761846363281951L;
    protected Sequence m_Actors;
    protected StorageName m_StorageName;
    protected int m_Interval;
    protected QueueEventRunnable m_Runnable;

    public String globalInfo() {
        return "Executes its sub-flow after a predefined number of milli-seconds.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actor", "actors", (Object)new AbstractActor[0]);
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("queue"));
        this.m_OptionManager.add("interval", "interval", (Object)50, (Number)1, null);
    }

    protected void initialize() {
        super.initialize();
        this.m_Actors = new Sequence();
        this.m_Actors.setAllowSource(true);
        this.m_Actors.setAllowStandalones(true);
        this.m_Runnable = null;
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"interval", (Object)this.m_Interval, (String)", interval: ");
        return result;
    }

    public void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        this.m_Actors.setLoggingLevel(value);
    }

    protected Sequence getInternalActors() {
        return this.m_Actors;
    }

    protected String checkActors(AbstractActor[] actors) {
        return null;
    }

    protected void updateParent() {
        this.m_Actors.setParent(null);
        this.m_Actors.setParent((AbstractActor)this);
    }

    public void setActors(AbstractActor[] value) {
        String msg = this.checkActors(value);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_Actors.setActors(value);
        this.reset();
        this.updateParent();
    }

    public AbstractActor[] getActors() {
        return this.m_Actors.getActors();
    }

    public String actorsTipText() {
        return "The actor to use for processing the queue element.";
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the queue in the internal storage.";
    }

    public void setInterval(int value) {
        this.m_Interval = value;
        this.reset();
    }

    public int getInterval() {
        return this.m_Interval;
    }

    public String intervalTipText() {
        return "The polling interval in milli-seconds.";
    }

    public int size() {
        return this.m_Actors.size();
    }

    public AbstractActor get(int index) {
        return this.m_Actors.get(index);
    }

    public void set(int index, AbstractActor actor) {
        this.m_Actors.set(index, actor);
        this.reset();
        this.updateParent();
    }

    public int indexOf(String actor) {
        return this.m_Actors.indexOf(actor);
    }

    public void add(AbstractActor actor) {
        this.add(this.size(), actor);
    }

    public void add(int index, AbstractActor actor) {
        this.m_Actors.add(index, actor);
        this.reset();
        this.updateParent();
    }

    public AbstractActor remove(int index) {
        AbstractActor result = this.m_Actors.remove(index);
        this.reset();
        return result;
    }

    public void removeAll() {
        this.m_Actors.removeAll();
        this.reset();
    }

    public void setHeadless(boolean value) {
        super.setHeadless(value);
        this.m_Actors.setHeadless(value);
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return this.m_Actors.getActorHandlerInfo();
    }

    public int active() {
        return this.m_Actors.active();
    }

    public AbstractActor firstActive() {
        return this.m_Actors.firstActive();
    }

    public AbstractActor lastActive() {
        return this.m_Actors.lastActive();
    }

    public String check() {
        return this.m_Actors.check();
    }

    protected void forceVariables(Variables value) {
        super.forceVariables(value);
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setVariables(value);
        }
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.m_Actors.setUp();
        }
        return result;
    }

    protected String doExecute() {
        this.m_Runnable = new QueueEventRunnable(this);
        this.m_Runnable.setLoggingLevel(this.getLoggingLevel());
        new Thread((Runnable)((Object)this.m_Runnable)).start();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopRunnable() {
        if (this.m_Runnable != null) {
            this.m_Runnable.stopExecution();
            while (this.m_Runnable.isRunning()) {
                try {
                    QueueEvent queueEvent = this;
                    synchronized (queueEvent) {
                        ((Object)((Object)this)).wait(100L);
                    }
                }
                catch (Exception exception) {
                }
            }
            this.m_Runnable = null;
        }
    }

    public void stopExecution() {
        this.m_Actors.stopExecution();
        this.stopRunnable();
        super.stopExecution();
    }

    public void wrapUp() {
        if (this.m_Actors != null) {
            this.m_Actors.wrapUp();
        }
        this.stopRunnable();
        super.wrapUp();
    }

    public void cleanUp() {
        if (this.m_Actors != null) {
            this.m_Actors.cleanUp();
        }
        super.cleanUp();
    }

    public static class QueueEventRunnable
    extends EventRunnable<QueueEvent> {
        private static final long serialVersionUID = -8381810698902721155L;

        public QueueEventRunnable(QueueEvent owner) {
            super(owner);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRun() {
            StorageQueueHandler queue = (StorageQueueHandler)((QueueEvent)((Object)this.getOwner())).getStorageHandler().getStorage().get(((QueueEvent)((Object)this.getOwner())).getStorageName());
            if (queue != null) {
                while (!this.m_Stopped) {
                    try {
                        if (queue.size() > 0) {
                            Token token = new Token(queue.remove());
                            ((QueueEvent)((Object)this.getOwner())).getInternalActors().input(token);
                            ((QueueEvent)((Object)this.getOwner())).getInternalActors().execute();
                            continue;
                        }
                        QueueEventRunnable queueEventRunnable = this;
                        synchronized (queueEventRunnable) {
                            ((Object)((Object)this)).wait(((QueueEvent)((Object)this.getOwner())).getInterval());
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().log(Level.SEVERE, "Error during execution occurred!", e);
                    }
                }
            } else if (this.isLoggingEnabled()) {
                this.getLogger().info("Queue '" + ((QueueEvent)((Object)this.getOwner())).getStorageName() + "' not found, exiting.");
            }
        }
    }
}

