/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.driftdetection;

import moa.classifiers.core.driftdetection.DriftDetectionMethod;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.IntOption;
import moa.tasks.TaskMonitor;

public class DDM
extends AbstractOptionHandler
implements DriftDetectionMethod {
    private static final long serialVersionUID = -3518369648142099719L;
    public IntOption minNumInstancesOption = new IntOption("minNumInstances", 'n', "The minimum number of instances before permitting detecting change.", 30, 0, Integer.MAX_VALUE);
    private int m_n;
    private double m_p;
    private double m_s;
    private double m_psmin;
    private double m_pmin;
    private double m_smin;

    public DDM() {
        this.initialize();
    }

    private void initialize() {
        this.m_n = 1;
        this.m_p = 1.0;
        this.m_s = 0.0;
        this.m_psmin = Double.MAX_VALUE;
        this.m_pmin = Double.MAX_VALUE;
        this.m_smin = Double.MAX_VALUE;
    }

    @Override
    public int computeNextVal(boolean prediction) {
        this.m_p = !prediction ? (this.m_p += (1.0 - this.m_p) / (double)this.m_n) : (this.m_p -= this.m_p / (double)this.m_n);
        this.m_s = Math.sqrt(this.m_p * (1.0 - this.m_p) / (double)this.m_n);
        ++this.m_n;
        if (this.m_n < this.minNumInstancesOption.getValue()) {
            return 0;
        }
        if (this.m_p + this.m_s <= this.m_psmin) {
            this.m_pmin = this.m_p;
            this.m_smin = this.m_s;
            this.m_psmin = this.m_p + this.m_s;
        }
        if (this.m_n > this.minNumInstancesOption.getValue() && this.m_p + this.m_s > this.m_pmin + 3.0 * this.m_smin) {
            System.out.println(this.m_p + ",D");
            this.initialize();
            return 2;
        }
        if (this.m_p + this.m_s > this.m_pmin + 2.0 * this.m_smin) {
            System.out.println(this.m_p + ",W");
            return 1;
        }
        System.out.println(this.m_p + ",N");
        return 0;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }

    @Override
    public DriftDetectionMethod copy() {
        return (DriftDetectionMethod)super.copy();
    }
}

