/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Random;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Regressor;
import moa.classifiers.core.attributeclassobservers.AttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.BinaryTreeNumericAttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.BinaryTreeNumericAttributeClassObserverRegression;
import moa.classifiers.core.attributeclassobservers.NominalAttributeClassObserver;
import moa.classifiers.rules.Predicates;
import moa.classifiers.rules.Rule;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.StringUtils;
import moa.options.FlagOption;
import moa.options.FloatOption;
import moa.options.IntOption;
import moa.options.MultiChoiceOption;
import weka.core.Instance;
import weka.core.Utils;

public class AMRules
extends AbstractClassifier
implements Regressor {
    private static final long serialVersionUID = 1L;
    protected AutoExpandVector<AttributeClassObserver> attributeObservers;
    protected ArrayList<ArrayList<Double>> saveBestValGlobalSDR = new ArrayList();
    protected ArrayList<Double> saveTheBest = new ArrayList();
    protected ArrayList<Rule> ruleSet = new ArrayList();
    protected ArrayList<Rule> ruleSetAnomalies = new ArrayList();
    protected ArrayList<Integer> ruleAnomaliesIndex = new ArrayList();
    protected ArrayList<ArrayList<Integer>> caseAnomaly = new ArrayList();
    protected ArrayList<ArrayList<ArrayList<Double>>> ruleAttribAnomalyStatistics = new ArrayList();
    protected ArrayList<Double> targetValue = new ArrayList();
    protected ArrayList<Double> numTargetValue = new ArrayList();
    protected ArrayList<Double> ruleTargetMean = new ArrayList();
    protected ArrayList<Double> ruleTargetMeanAnomalies = new ArrayList();
    protected double[] weightAttributeDefault;
    protected DoubleVector saveBestGlobalSDR = new DoubleVector();
    protected DoubleVector attributeStatisticsDefault = new DoubleVector();
    protected DoubleVector squaredAttributeStatisticsDefault = new DoubleVector();
    protected DoubleVector attributesProbabilityDefault = new DoubleVector();
    protected Instance instance;
    protected boolean resetDefault = true;
    protected double actualClassStatisticsDefault = 0.0;
    protected double squaredActualClassStatisticsDefault = 0.0;
    protected double sumTotalLeft;
    protected double sumTotalRight;
    protected double sumSqTotalLeft;
    protected double sumSqTotalRight;
    protected double rightTotal;
    protected double total;
    protected double maxSDR = 0.0;
    protected double splitpoint = 0.0;
    protected double symbolTemp = 0.0;
    protected double symbol = 0.0;
    protected double sumTotalTemp = 0.0;
    protected double sumTotal = 0.0;
    protected double numSomaTotalTemp = 0.0;
    protected double numSomaTotal = 0.0;
    protected double learnRateDecay = 0.001;
    protected double initLearnRate = 0.1;
    protected int instancesSeenDefault = 0;
    protected int instancesSeenDefaultTest = 0;
    protected int numInstTest = 0;
    protected int numInstance = 0;
    protected int maxInt = Integer.MAX_VALUE;
    BinaryTreeNumericAttributeClassObserverRegression.Node root;
    Predicates pred;
    public static final double NORMAL_CONSTANT = Math.sqrt(Math.PI * 2);
    public FloatOption splitConfidenceOption = new FloatOption("splitConfidence", 'c', "The allowable error in split decision, values closer to 0 will take longer to decide.", 1.0E-7, 0.0, 1.0);
    public FloatOption tieThresholdOption = new FloatOption("tieThreshold", 't', "Threshold below which a split will be forced to break ties.", 0.05, 0.0, 1.0);
    public FloatOption pageHinckleyAlphaOption = new FloatOption("PageHinckleyAlpha", 'a', "The alpha value to use in the Page Hinckley change detection tests.", 0.005, 0.0, 1.0);
    public FloatOption anomalyProbabilityThresholdOption = new FloatOption("anomalyprobabilityThreshold", 'o', "The threshold value.", 0.99, 0.0, 1.0);
    public FloatOption probabilityThresholdOption = new FloatOption("probabilityThreshold", 'k', "The threshold value.", 0.1, 0.0, 1.0);
    public IntOption pageHinckleyThresholdOption = new IntOption("PageHinckleyThreshold", 'h', "The threshold value to be used in the Page Hinckley change detection tests.", 50, 0, Integer.MAX_VALUE);
    public IntOption anomalyNumInstThresholdOption = new IntOption("anomalyThreshold", 'i', "The threshold value to be used in the anomaly detection.", 15, 0, Integer.MAX_VALUE);
    public IntOption gracePeriodOption = new IntOption("gracePeriod", 'g', "The number of instances a leaf should observe between split attempts.", 200, 0, Integer.MAX_VALUE);
    public FloatOption learningRatioOption = new FloatOption("learningRatio", 'w', "Learning ratio to use for training the Perceptrons in the leaves.", 0.01);
    public FloatOption seedOption = new FloatOption("randomSeed", 'x', "The alpha value to use in the Page Hinckley change detection tests.", 100.0);
    public MultiChoiceOption predictionFunctionOption = new MultiChoiceOption("predictionFunctionOption", 'z', "The prediction function to use.", new String[]{"Adaptative", "Perceptron", "Target Mean"}, new String[]{"Adaptative", "Perceptron", "Target Mean"}, 0);
    public FlagOption orderedRulesOption = new FlagOption("orderedRules", 'r', "orderedRules.");
    public FlagOption anomalyDetectionOption = new FlagOption("anomalyDetection", 'u', "anomaly Detection.");
    public FlagOption learningRatio_Decay_or_Const_Option = new FlagOption("learningRatio_Decay_or_Const", 'd', "learning Ratio Decay or const parameter.");

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        double[] votes = new double[1];
        ++this.numInstTest;
        switch (this.predictionFunctionOption.getChosenIndex()) {
            case 0: {
                if (this.orderedRulesOption.isSet()) {
                    if (this.numInstTest > 100) {
                        double targetMeanError;
                        double perceptronPrediction = this.getVotesOrderedRulesPerceptron(inst);
                        double targetMeanPrediction = this.getVotesOrderedRulesTargetMean(inst);
                        double perceptronError = Math.abs(inst.classValue() - perceptronPrediction);
                        if (perceptronError < (targetMeanError = Math.abs(inst.classValue() - targetMeanPrediction))) {
                            votes[0] = perceptronPrediction;
                            break;
                        }
                        votes[0] = targetMeanPrediction;
                        break;
                    }
                    votes[0] = this.getVotesOrderedRulesTargetMean(inst);
                    break;
                }
                if (this.numInstTest > 100) {
                    double targetMeanError;
                    double perceptronPrediction = this.getVotesUnorderedRulesPerceptron(inst);
                    double targetMeanPrediction = this.getVotesUnorderedRulesTargetMean(inst);
                    double perceptronError = Math.abs(inst.classValue() - perceptronPrediction);
                    if (perceptronError < (targetMeanError = Math.abs(inst.classValue() - targetMeanPrediction))) {
                        votes[0] = perceptronPrediction;
                        break;
                    }
                    votes[0] = targetMeanPrediction;
                    break;
                }
                votes[0] = this.getVotesUnorderedRulesTargetMean(inst);
                break;
            }
            case 1: {
                if (this.orderedRulesOption.isSet()) {
                    if (this.numInstTest > 100) {
                        votes[0] = this.getVotesOrderedRulesPerceptron(inst);
                        break;
                    }
                    votes[0] = this.getVotesOrderedRulesTargetMean(inst);
                    break;
                }
                if (this.numInstTest > 100) {
                    votes[0] = this.getVotesUnorderedRulesPerceptron(inst);
                    break;
                }
                votes[0] = this.getVotesUnorderedRulesTargetMean(inst);
                break;
            }
            case 2: {
                votes[0] = this.orderedRulesOption.isSet() ? this.getVotesOrderedRulesTargetMean(inst) : this.getVotesUnorderedRulesTargetMean(inst);
            }
        }
        return votes;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public void resetLearningImpl() {
        this.attributeObservers = new AutoExpandVector();
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        ++this.numInstance;
        int countRuleFiredTrue = 0;
        boolean ruleFired = false;
        this.instance = inst;
        for (int j = 0; j < this.ruleSet.size(); ++j) {
            if (!this.ruleSet.get(j).ruleEvaluate(inst)) continue;
            ++countRuleFiredTrue;
            this.saveBestValGlobalSDR = new ArrayList();
            this.saveBestGlobalSDR = new DoubleVector();
            this.saveTheBest = new ArrayList();
            double anomaly = this.computeAnomaly(this.ruleSet.get(j), j, inst);
            if (this.ruleSet.get((int)j).instancesSeen <= this.anomalyNumInstThresholdOption.getValue() || anomaly < this.anomalyProbabilityThresholdOption.getValue() && this.anomalyDetectionOption.isSet() || !this.anomalyDetectionOption.isSet()) {
                for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                    int instAttIndex = AMRules.modelAttIndexToInstanceAttIndex(i, inst);
                    AttributeClassObserver obs = this.ruleSet.get((int)j).observers.get(i);
                    if (obs == null) {
                        obs = inst.attribute(instAttIndex).isNominal() ? this.newNominalClassObserver() : this.newNumericClassObserverRegression();
                        this.ruleSet.get((int)j).observers.set(i, obs);
                    }
                    obs.observeAttributeTarget(inst.value(instAttIndex), inst.classValue());
                }
                double RuleError = this.computeRuleError(inst, this.ruleSet.get(j), j);
                boolean ph = this.PageHinckleyTest(RuleError, this.pageHinckleyThresholdOption.getValue(), this.ruleSet.get(j));
                if (ph) {
                    this.ruleSet.remove(j);
                    this.targetValue.remove(j);
                    this.numTargetValue.remove(j);
                    this.ruleTargetMean.remove(j);
                } else {
                    this.expandeRule(this.ruleSet.get(j), j, inst);
                }
            }
            if (this.orderedRulesOption.isSet()) break;
        }
        if (!(ruleFired = countRuleFiredTrue > 0)) {
            this.saveBestValGlobalSDR = new ArrayList();
            this.saveBestGlobalSDR = new DoubleVector();
            this.saveTheBest = new ArrayList();
            double anomalies = this.computeAnomalyDefaultRules(inst);
            if (this.instancesSeenDefault <= this.anomalyNumInstThresholdOption.getValue() || anomalies < this.anomalyProbabilityThresholdOption.getValue() && this.anomalyDetectionOption.isSet() || !this.anomalyDetectionOption.isSet()) {
                for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                    int instAttIndex = AMRules.modelAttIndexToInstanceAttIndex(i, inst);
                    AttributeClassObserver obs = this.attributeObservers.get(i);
                    if (obs == null) {
                        obs = inst.attribute(instAttIndex).isNominal() ? this.newNominalClassObserver() : this.newNumericClassObserverRegression();
                        this.attributeObservers.set(i, obs);
                    }
                    obs.observeAttributeTarget(inst.value(instAttIndex), inst.classValue());
                }
                this.initialyPerceptron(inst);
                this.updateAttWeight(inst, this.weightAttributeDefault, this.squaredActualClassStatisticsDefault, this.actualClassStatisticsDefault, this.squaredAttributeStatisticsDefault, this.attributeStatisticsDefault, this.instancesSeenDefault, this.resetDefault);
                this.updatedefaultRuleStatistics(inst);
                this.createRule(inst);
            }
        }
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        if (this.anomalyDetectionOption.isSet()) {
            this.getModelDescriptionAnomalyDetection(out, indent);
        } else {
            this.getModelDescriptionNoAnomalyDetection(out, indent);
        }
    }

    public void getModelDescriptionAnomalyDetection(StringBuilder out, int indent) {
        StringUtils.appendNewline(out);
        for (int k = 0; k < this.ruleSetAnomalies.size(); ++k) {
            StringUtils.appendIndented(out, indent, "Case: " + this.caseAnomaly.get(k).get(0) + "   Anomaly Score: " + this.caseAnomaly.get(k).get(1) + "%");
            StringUtils.appendNewline(out);
            if (this.ruleSetAnomalies.get((int)k).predicateSet.isEmpty()) {
                StringUtils.appendNewline(out);
                StringUtils.appendIndented(out, indent, "Default Rule { } -> ");
                StringUtils.appendIndented(out, indent, "TargetAverage: " + this.round(this.ruleTargetMeanAnomalies.get(k)) + "  ");
                StringUtils.appendNewline(out);
            } else {
                StringUtils.appendIndented(out, indent, "Rule " + this.ruleAnomaliesIndex.get(k) + ": ");
                for (int i = 0; i < this.ruleSetAnomalies.get((int)k).predicateSet.size(); ++i) {
                    String nam;
                    if (this.ruleSetAnomalies.get((int)k).predicateSet.size() == 1) {
                        if (this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getSymbol() == -1.0) {
                            nam = this.instance.attribute((int)this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                            StringUtils.appendIndented(out, indent, nam + " <= " + this.round(this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getValue()) + " --> ");
                            StringUtils.appendIndented(out, indent, "TargetAverage: " + this.round(this.ruleTargetMeanAnomalies.get(k)) + "  ");
                            StringUtils.appendNewline(out);
                            continue;
                        }
                        nam = this.instance.attribute((int)this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                        StringUtils.appendIndented(out, indent, nam + " > " + this.round(this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getValue()) + " --> ");
                        StringUtils.appendIndented(out, indent, "TargetAverage: " + this.round(this.ruleTargetMeanAnomalies.get(k)) + "  ");
                        StringUtils.appendNewline(out);
                        continue;
                    }
                    if (this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getSymbol() == -1.0) {
                        nam = this.instance.attribute((int)this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                        StringUtils.appendIndented(out, indent, nam + " <= " + this.round(this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getValue()) + " ");
                    } else {
                        nam = this.instance.attribute((int)this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                        StringUtils.appendIndented(out, indent, nam + " > " + this.round(this.ruleSetAnomalies.get((int)k).predicateSet.get(i).getValue()) + " ");
                    }
                    if (i < this.ruleSetAnomalies.get((int)k).predicateSet.size() - 1) {
                        StringUtils.appendIndented(out, indent, "and ");
                        continue;
                    }
                    StringUtils.appendIndented(out, indent, " --> ");
                    StringUtils.appendIndented(out, indent, "TargetAverage: " + this.round(this.ruleTargetMeanAnomalies.get(k)) + "  ");
                    StringUtils.appendNewline(out);
                }
            }
            for (int z = 0; z < this.ruleAttribAnomalyStatistics.get(k).size(); ++z) {
                String s = String.format("%.3e", this.ruleAttribAnomalyStatistics.get(k).get(z).get(4));
                StringUtils.appendIndented(out, indent, this.instance.attribute(this.ruleAttribAnomalyStatistics.get(k).get(z).get(0).intValue()).name() + "=" + this.round(this.ruleAttribAnomalyStatistics.get(k).get(z).get(1)) + "   (" + this.round(this.ruleAttribAnomalyStatistics.get(k).get(z).get(2)) + " +- " + this.round(this.ruleAttribAnomalyStatistics.get(k).get(z).get(3)) + ")   P=" + s);
                StringUtils.appendNewline(out);
            }
            StringUtils.appendNewline(out);
            StringUtils.appendNewline(out);
        }
    }

    public void getModelDescriptionNoAnomalyDetection(StringBuilder out, int indent) {
        StringUtils.appendNewline(out);
        StringUtils.appendIndented(out, indent, "Default Rule { } -> ");
        StringUtils.appendIndented(out, indent, "TargetAverage: " + this.round(this.observersDistrib(this.instance, this.attributeObservers)) + "  ");
        StringUtils.appendNewline(out);
        StringUtils.appendIndented(out, indent, "Number of Rule: " + this.ruleSet.size());
        StringUtils.appendNewline(out);
        StringUtils.appendNewline(out);
        for (int k = 0; k < this.ruleSet.size(); ++k) {
            StringUtils.appendIndented(out, indent, "Rule " + (k + 1) + ": ");
            for (int i = 0; i < this.ruleSet.get((int)k).predicateSet.size(); ++i) {
                String nam;
                if (this.ruleSet.get((int)k).predicateSet.size() == 1) {
                    if (this.ruleSet.get((int)k).predicateSet.get(i).getSymbol() == -1.0) {
                        nam = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                        StringUtils.appendIndented(out, indent, nam + " <= " + this.ruleSet.get((int)k).predicateSet.get(i).getValue() + " --> ");
                        StringUtils.appendIndented(out, indent, "TargetAverage: " + this.round(this.ruleTargetMean.get(k)) + "  ");
                        StringUtils.appendNewline(out);
                        StringUtils.appendNewline(out);
                        continue;
                    }
                    nam = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    StringUtils.appendIndented(out, indent, nam + " > " + this.ruleSet.get((int)k).predicateSet.get(i).getValue() + " --> ");
                    StringUtils.appendIndented(out, indent, "TargetAverage: " + this.round(this.ruleTargetMean.get(k)) + "  ");
                    StringUtils.appendNewline(out);
                    StringUtils.appendNewline(out);
                    continue;
                }
                if (this.ruleSet.get((int)k).predicateSet.get(i).getSymbol() == -1.0) {
                    nam = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    StringUtils.appendIndented(out, indent, nam + " <= " + this.ruleSet.get((int)k).predicateSet.get(i).getValue() + " ");
                } else {
                    nam = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    StringUtils.appendIndented(out, indent, nam + " > " + this.ruleSet.get((int)k).predicateSet.get(i).getValue() + " ");
                }
                if (i < this.ruleSet.get((int)k).predicateSet.size() - 1) {
                    StringUtils.appendIndented(out, indent, "and ");
                    continue;
                }
                StringUtils.appendIndented(out, indent, " --> ");
                StringUtils.appendIndented(out, indent, "TargetAverage: " + this.round(this.ruleTargetMean.get(k)) + "  ");
                StringUtils.appendNewline(out);
                StringUtils.appendNewline(out);
            }
            StringUtils.appendNewline(out);
        }
    }

    protected double computeSDR() {
        double standardDR = 0.0;
        double sdS = 0.0;
        double sdSL = 0.0;
        double sdSR = 0.0;
        double NL = this.total - this.rightTotal;
        double NR = this.rightTotal;
        double N = NL + NR;
        double sumTotal = this.sumTotalLeft + this.sumTotalRight;
        double sumSqTotal = this.sumSqTotalLeft + this.sumSqTotalRight;
        sdS = Math.sqrt(1.0 / N * (sumSqTotal - 1.0 / N * Math.pow(sumTotal, 2.0)));
        sdSL = Math.sqrt(1.0 / NL * (this.sumSqTotalLeft - 1.0 / NL * Math.pow(this.sumTotalLeft, 2.0)));
        if (sdSL >= (sdSR = Math.sqrt(1.0 / NR * (this.sumSqTotalRight - 1.0 / NR * Math.pow(this.sumTotalRight, 2.0))))) {
            this.symbolTemp = -1.0;
            this.sumTotalTemp = this.sumTotalLeft;
            this.numSomaTotalTemp = NL;
        } else {
            this.symbolTemp = 1.0;
            this.sumTotalTemp = this.sumTotalRight;
            this.numSomaTotalTemp = NR;
        }
        standardDR = sdS - NL / N * sdSL - NR / N * sdSR;
        return standardDR;
    }

    protected double[] getBestSecondBestSDR(DoubleVector SDR) {
        double[] SDRValues = new double[2];
        double best = 0.0;
        double secondBest = 0.0;
        for (int i = 0; i < SDR.numValues(); ++i) {
            if (SDR.getValue(i) > best) {
                secondBest = best;
                best = SDR.getValue(i);
                continue;
            }
            if (!(SDR.getValue(i) > secondBest)) continue;
            secondBest = SDR.getValue(i);
        }
        SDRValues[0] = best;
        SDRValues[1] = secondBest;
        return SDRValues;
    }

    protected void findBestSplit(BinaryTreeNumericAttributeClassObserverRegression.Node root1) {
        if (root1.left != null) {
            this.findBestSplit(root1.left);
        }
        this.sumTotalLeft += root1.lessThan[0];
        this.sumTotalRight -= root1.lessThan[0];
        this.sumSqTotalLeft += root1.lessThan[1];
        this.sumSqTotalRight -= root1.lessThan[1];
        this.rightTotal -= root1.lessThan[2];
        double standardDR = this.computeSDR();
        if (this.maxSDR < standardDR) {
            this.maxSDR = standardDR;
            this.splitpoint = root1.cut_point;
            this.symbol = this.symbolTemp;
            this.sumTotal = this.sumTotalTemp;
            this.numSomaTotal = this.numSomaTotalTemp;
        }
        if (root1.right != null) {
            this.findBestSplit(root1.right);
        }
        this.sumTotalLeft -= root1.lessThan[0];
        this.sumTotalRight += root1.lessThan[0];
        this.sumSqTotalLeft -= root1.lessThan[1];
        this.sumSqTotalRight += root1.lessThan[1];
        this.rightTotal += root1.lessThan[2];
    }

    public void theBestAttributes(Instance instance, AutoExpandVector<AttributeClassObserver> observersParameter) {
        for (int z = 0; z < instance.numAttributes() - 1; ++z) {
            int instAttIndex = AMRules.modelAttIndexToInstanceAttIndex(z, instance);
            if (!instance.attribute(instAttIndex).isNumeric()) continue;
            this.root = ((BinaryTreeNumericAttributeClassObserverRegression)observersParameter.get((int)z)).root1;
            this.sumTotalLeft = 0.0;
            this.sumTotalRight = this.root.lessThan[0] + this.root.greaterThan[0];
            this.sumSqTotalLeft = 0.0;
            this.sumSqTotalRight = this.root.lessThan[1] + this.root.greaterThan[1];
            this.rightTotal = this.total = this.root.lessThan[2] + this.root.greaterThan[2];
            this.maxSDR = 0.0;
            this.symbol = 0.0;
            this.sumTotal = 0.0;
            this.numSomaTotal = 0.0;
            this.findBestSplit(this.root);
            ArrayList<Double> saveTheBestAtt = new ArrayList<Double>();
            saveTheBestAtt.add(this.splitpoint);
            saveTheBestAtt.add(this.maxSDR);
            saveTheBestAtt.add(this.symbol);
            saveTheBestAtt.add(this.sumTotal);
            saveTheBestAtt.add(this.numSomaTotal);
            this.saveBestValGlobalSDR.add(saveTheBestAtt);
            this.saveBestGlobalSDR.setValue(z, this.maxSDR);
        }
    }

    public boolean checkBestAttrib(double n) {
        double range;
        double hoeffdingBound;
        double bestSDR;
        boolean isTheBest = false;
        double[] SDRValues = this.getBestSecondBestSDR(this.saveBestGlobalSDR);
        double secondBestSDR = SDRValues[1];
        double r = secondBestSDR / (bestSDR = SDRValues[0]);
        double upperBound = r + (hoeffdingBound = this.computeHoeffdingBound(range = Utils.log2((double)1.0), this.splitConfidenceOption.getValue(), n));
        if (upperBound < 1.0 || hoeffdingBound < this.tieThresholdOption.getValue()) {
            for (int i = 0; i < this.saveBestValGlobalSDR.size(); ++i) {
                if (bestSDR != this.saveBestValGlobalSDR.get(i).get(1)) continue;
                this.saveTheBest.add(this.saveBestValGlobalSDR.get(i).get(0));
                this.saveTheBest.add(this.saveBestValGlobalSDR.get(i).get(1));
                this.saveTheBest.add(this.saveBestValGlobalSDR.get(i).get(2));
                this.saveTheBest.add(Double.valueOf(i));
                this.saveTheBest.add(this.saveBestValGlobalSDR.get(i).get(3));
                this.saveTheBest.add(this.saveBestValGlobalSDR.get(i).get(4));
                break;
            }
            isTheBest = true;
        } else {
            isTheBest = false;
        }
        return isTheBest;
    }

    public double computeHoeffdingBound(double range, double confidence, double n) {
        return Math.sqrt(range * range * Math.log(1.0 / confidence) / (2.0 * n));
    }

    public double computeMean(double sum, int size) {
        return sum / (double)size;
    }

    public double computeSD(double squaredVal, double val, int size) {
        return Math.sqrt((squaredVal - val * val / (double)size) / (double)size);
    }

    public double computeProbability(double mean, double sd, double value) {
        sd += 1.0E-5;
        double probability = 0.0;
        double diff = value - mean;
        if (sd > 0.0) {
            double k = Math.abs(value - mean) / sd;
            probability = k > 1.0 ? 1.0 / (k * k) : Math.exp(-(diff * diff / (2.0 * sd * sd)));
        }
        return probability;
    }

    public double computeAnomaly(Rule rl, int ruleIndex, Instance inst) {
        double anomaly;
        ArrayList<Integer> caseAnomalyTemp = new ArrayList<Integer>();
        ArrayList AttribAnomalyStatisticTemp2 = new ArrayList();
        double D = 0.0;
        double N = 0.0;
        if (rl.instancesSeen > this.anomalyNumInstThresholdOption.getValue() && this.anomalyDetectionOption.isSet()) {
            for (int x = 0; x < inst.numAttributes() - 1; ++x) {
                double sd;
                double mean;
                double probability;
                ArrayList<Double> AttribAnomalyStatisticTemp = new ArrayList<Double>();
                if (!inst.attribute(x).isNumeric() || (probability = this.computeProbability(mean = this.computeMean(rl.attributeStatistics.getValue(x), rl.instancesSeen), sd = this.computeSD(rl.squaredAttributeStatistics.getValue(x), rl.attributeStatistics.getValue(x), rl.instancesSeen), inst.value(x))) == 0.0) continue;
                D += Math.log(probability);
                if (!(probability < this.probabilityThresholdOption.getValue())) continue;
                N += Math.log(probability);
                AttribAnomalyStatisticTemp.add(Double.valueOf(x));
                AttribAnomalyStatisticTemp.add(inst.value(x));
                AttribAnomalyStatisticTemp.add(mean);
                AttribAnomalyStatisticTemp.add(sd);
                AttribAnomalyStatisticTemp.add(probability);
                AttribAnomalyStatisticTemp2.add(AttribAnomalyStatisticTemp);
            }
        }
        if ((anomaly = Math.abs(N / D)) >= this.anomalyProbabilityThresholdOption.getValue()) {
            caseAnomalyTemp.add(this.numInstance);
            double val = anomaly * 100.0;
            caseAnomalyTemp.add((int)val);
            this.caseAnomaly.add(caseAnomalyTemp);
            this.ruleSetAnomalies.add(this.ruleSet.get(ruleIndex));
            this.ruleTargetMeanAnomalies.add(this.ruleTargetMean.get(ruleIndex));
            this.ruleAnomaliesIndex.add(ruleIndex + 1);
            this.ruleAttribAnomalyStatistics.add(AttribAnomalyStatisticTemp2);
        }
        return anomaly;
    }

    public double computeAnomalyDefaultRules(Instance inst) {
        double anomalies;
        double D = 0.0;
        double N = 0.0;
        ArrayList<Integer> caseAnomalyTemp = new ArrayList<Integer>();
        ArrayList AttribAnomalyStatisticTemp2 = new ArrayList();
        if (this.instancesSeenDefault > this.anomalyNumInstThresholdOption.getValue() && this.anomalyDetectionOption.isSet()) {
            for (int x = 0; x < inst.numAttributes() - 1; ++x) {
                double sd;
                double mean;
                double probability;
                ArrayList<Double> AttribAnomalyStatisticTemp = new ArrayList<Double>();
                if (!inst.attribute(x).isNumeric() || (probability = this.computeProbability(mean = this.computeMean(this.attributeStatisticsDefault.getValue(x), this.instancesSeenDefault), sd = this.computeSD(this.squaredAttributeStatisticsDefault.getValue(x), this.attributeStatisticsDefault.getValue(x), this.instancesSeenDefault), inst.value(x))) == 0.0) continue;
                D += Math.log(probability);
                if (!(probability < this.probabilityThresholdOption.getValue())) continue;
                N += Math.log(probability);
                AttribAnomalyStatisticTemp.add(Double.valueOf(x));
                AttribAnomalyStatisticTemp.add(inst.value(x));
                AttribAnomalyStatisticTemp.add(mean);
                AttribAnomalyStatisticTemp.add(sd);
                AttribAnomalyStatisticTemp.add(probability);
                AttribAnomalyStatisticTemp2.add(AttribAnomalyStatisticTemp);
            }
        }
        if ((anomalies = Math.abs(N / D)) >= this.anomalyProbabilityThresholdOption.getValue()) {
            caseAnomalyTemp.add(this.numInstance);
            double val = anomalies * 100.0;
            caseAnomalyTemp.add((int)val);
            this.caseAnomaly.add(caseAnomalyTemp);
            Rule rule = new Rule();
            this.ruleSetAnomalies.add(rule);
            this.ruleTargetMeanAnomalies.add(this.observersDistrib(this.instance, this.attributeObservers));
            this.ruleAnomaliesIndex.add(-1);
            this.ruleAttribAnomalyStatistics.add(AttribAnomalyStatisticTemp2);
        }
        return anomalies;
    }

    protected int observersNumberInstance(Instance inst, AutoExpandVector<AttributeClassObserver> observerss) {
        int numberInstance = 0;
        for (int z = 0; z < inst.numAttributes() - 1; ++z) {
            BinaryTreeNumericAttributeClassObserverRegression.Node rootNode;
            numberInstance = 0;
            int instAttIndex = AMRules.modelAttIndexToInstanceAttIndex(z, inst);
            if (!inst.attribute(instAttIndex).isNumeric() || (rootNode = ((BinaryTreeNumericAttributeClassObserverRegression)observerss.get((int)z)).root1) == null) continue;
            numberInstance = (int)(rootNode.lessThan[2] + rootNode.greaterThan[2]);
            break;
        }
        return numberInstance;
    }

    protected void reanicializeRuleStatistic(Rule rl) {
        rl.reset = false;
        rl.instancesSeen = 0;
        rl.actualClassStatistics = 0.0;
        rl.squaredActualClassStatistics = 0.0;
        rl.attributeStatistics = new DoubleVector();
        rl.squaredAttributeStatistics = new DoubleVector();
        rl.attributesProbability = new DoubleVector();
        rl.PHmT = 0.0;
        rl.PHMT = Double.MAX_VALUE;
        rl.XiSum = 0.0;
    }

    public double prediction(Instance inst, double[] weightAtt, double squaredActualClassStatistics, double actualClassStatistics, int instancesSeen, boolean reset) {
        double prediction = 0.0;
        if (!reset) {
            for (int j = 0; j < inst.numAttributes() - 1; ++j) {
                if (!inst.attribute(j).isNumeric()) continue;
                prediction += weightAtt[j] * inst.value(j);
            }
            prediction += weightAtt[inst.numAttributes() - 1];
        }
        double sdPredictedClass = this.computeSD(squaredActualClassStatistics, actualClassStatistics, instancesSeen);
        double outputDesnorm = 0.0;
        if (sdPredictedClass > 1.0E-7) {
            outputDesnorm = 3.0 * prediction * sdPredictedClass + actualClassStatistics / (double)instancesSeen;
        }
        return outputDesnorm;
    }

    public double updateAttWeight(Instance inst, double[] weightAtt, double squaredActualClassStatistics, double actualClassStatistics, DoubleVector squaredAttributeStatistics, DoubleVector attributeStatistics, int instancesSeen, boolean reset) {
        double learningRatio = 0.0;
        learningRatio = this.learningRatio_Decay_or_Const_Option.isSet() ? this.learningRatioOption.getValue() : this.initLearnRate / (1.0 + (double)instancesSeen * this.learnRateDecay);
        double predict = 0.0;
        if (instancesSeen > 30) {
            predict = this.prediction(inst, weightAtt, squaredActualClassStatistics, actualClassStatistics, instancesSeen, reset);
            double sdClass = this.computeSD(squaredActualClassStatistics, actualClassStatistics, instancesSeen);
            double actualClass = 0.0;
            double predictedClass = 0.0;
            if (sdClass > 1.0E-7) {
                actualClass = (inst.classValue() - actualClassStatistics / (double)instancesSeen) / (3.0 * sdClass);
                predictedClass = (predict - actualClassStatistics / (double)instancesSeen) / (3.0 * sdClass);
            }
            double delta = actualClass - predictedClass;
            for (int x = 0; x < inst.numAttributes() - 1; ++x) {
                if (!inst.attribute(x).isNumeric()) continue;
                double sd = Math.sqrt((squaredAttributeStatistics.getValue(x) - attributeStatistics.getValue(x) * attributeStatistics.getValue(x) / (double)instancesSeen) / (double)instancesSeen);
                double instanceValue = 0.0;
                instanceValue = inst.value(x) - attributeStatistics.getValue(x) / (double)instancesSeen;
                if (sd > 1.0E-7) {
                    instanceValue /= 3.0 * sd;
                }
                if (sd == 0.0) {
                    weightAtt[x] = 0.0;
                    continue;
                }
                int n = x;
                weightAtt[n] = weightAtt[n] + learningRatio * delta * instanceValue;
            }
            int n = inst.numAttributes() - 1;
            weightAtt[n] = weightAtt[n] + learningRatio * delta;
        }
        return predict;
    }

    public double[] getPredictionActualValueNormalized(Instance inst, Rule rl, int ruleIndex, double predict) {
        double[] values = new double[2];
        double predictVal = 0.0;
        double classActual = 0.0;
        double sd = this.computeSD(rl.squaredActualClassStatistics, rl.actualClassStatistics, rl.instancesSeen);
        if (this.predictionFunctionOption.getChosenIndex() == 2) {
            predictVal = (this.ruleTargetMean.get(ruleIndex) - rl.actualClassStatistics / (double)rl.instancesSeen) / (3.0 * sd);
            classActual = (inst.classValue() - rl.actualClassStatistics / (double)rl.instancesSeen) / (3.0 * sd);
        } else if (this.predictionFunctionOption.getChosenIndex() == 1) {
            if (rl.instancesSeen <= 30) {
                if (sd > 1.0E-7) {
                    predictVal = (this.ruleTargetMean.get(ruleIndex) - rl.actualClassStatistics / (double)rl.instancesSeen) / (3.0 * sd);
                    classActual = (inst.classValue() - rl.actualClassStatistics / (double)rl.instancesSeen) / (3.0 * sd);
                }
            } else if (sd > 1.0E-7) {
                predictVal = (predict - rl.actualClassStatistics / (double)rl.instancesSeen) / (3.0 * sd);
                classActual = (inst.classValue() - rl.actualClassStatistics / (double)rl.instancesSeen) / (3.0 * sd);
            }
        } else {
            double absolutErrorPerceptron;
            double absolutErrorTargetMean;
            double predictValTargetMean = 0.0;
            double predictValPerceptron = 0.0;
            if (sd > 1.0E-7) {
                predictValTargetMean = (this.ruleTargetMean.get(ruleIndex) - rl.actualClassStatistics / (double)rl.instancesSeen) / (3.0 * sd);
                predictValPerceptron = (predict - rl.actualClassStatistics / (double)rl.instancesSeen) / (3.0 * sd);
                classActual = (inst.classValue() - rl.actualClassStatistics / (double)rl.instancesSeen) / (3.0 * sd);
            }
            predictVal = (absolutErrorTargetMean = Math.abs(classActual - predictValTargetMean)) < (absolutErrorPerceptron = Math.abs(classActual - predictValPerceptron)) ? predictValTargetMean : predictValPerceptron;
        }
        values[0] = predictVal;
        values[1] = classActual;
        return values;
    }

    public void updateRuleStatistics(Instance inst, Rule rl, int ruleIndex) {
        ++rl.instancesSeen;
        double targetValueSize = this.numTargetValue.get(ruleIndex) + 1.0;
        double targetVal = this.targetValue.get(ruleIndex) + inst.classValue();
        this.targetValue.set(ruleIndex, targetVal);
        this.numTargetValue.set(ruleIndex, targetValueSize);
        this.setRuleTarget(this.targetValue.get(ruleIndex), this.numTargetValue.get(ruleIndex), ruleIndex);
        rl.ValorTargetRule = this.ruleTargetMean.get(ruleIndex);
        for (int s = 0; s < inst.numAttributes() - 1; ++s) {
            rl.attributeStatistics.addToValue(s, inst.value(s));
            rl.squaredAttributeStatistics.addToValue(s, inst.value(s) * inst.value(s));
        }
        rl.actualClassStatistics += inst.classValue();
        rl.squaredActualClassStatistics += inst.classValue() * inst.classValue();
    }

    public double computeRuleError(Instance inst, Rule rl, int ruleIndex) {
        double predict = this.updateAttWeight(inst, rl.weightAttribute, rl.squaredActualClassStatistics, rl.actualClassStatistics, rl.squaredAttributeStatistics, rl.attributeStatistics, rl.instancesSeen, rl.reset);
        double[] values = this.getPredictionActualValueNormalized(inst, rl, ruleIndex, predict);
        double predictVal = values[0];
        double classActual = values[1];
        this.updateRuleStatistics(inst, rl, ruleIndex);
        double xi = Math.abs(classActual - predictVal);
        rl.XiSum += xi;
        double RuleError = xi - rl.XiSum / (double)rl.instancesSeen - this.pageHinckleyAlphaOption.getValue();
        return RuleError;
    }

    public void AddPredUpdateRuleStatistics(Rule rl, int RuleIndex, double targetValorTotal, double contaTargetValorTotal) {
        rl.predicateSet.add(this.pred);
        this.targetValue.set(RuleIndex, targetValorTotal);
        this.numTargetValue.set(RuleIndex, contaTargetValorTotal);
        this.setRuleTarget(this.targetValue.get(RuleIndex), this.numTargetValue.get(RuleIndex), RuleIndex);
        rl.ValorTargetRule = this.ruleTargetMean.get(RuleIndex);
        this.reanicializeRuleStatistic(rl);
        rl.observers = new AutoExpandVector();
    }

    public void expandeRule(Rule rl, int ruleIndex, Instance inst) {
        this.ruleTargetData(inst, ruleIndex);
        int remainder = Integer.MAX_VALUE;
        int numInstanciaObservers = this.observersNumberInstance(inst, rl.observers);
        if (numInstanciaObservers != 0 && this.gracePeriodOption.getValue() != 0) {
            remainder = numInstanciaObservers % this.gracePeriodOption.getValue();
        }
        if (remainder == 0) {
            this.theBestAttributes(inst, rl.observers);
            boolean bestAttribute = this.checkBestAttrib(numInstanciaObservers);
            if (bestAttribute) {
                double attributeValue = this.saveTheBest.get(3);
                double symbol = this.saveTheBest.get(2);
                double value = this.saveTheBest.get(0);
                double targetValorTotal = this.saveTheBest.get(4);
                double contaTargetValorTotal = this.saveTheBest.get(5);
                this.pred = new Predicates(attributeValue, symbol, value);
                int countPred = 0;
                for (int i = 0; i < rl.predicateSet.size(); ++i) {
                    if (rl.predicateSet.get(i).getAttributeValue() == this.pred.getAttributeValue() && rl.predicateSet.get(i).getSymbol() == this.pred.getSymbol() && rl.predicateSet.get(i).getValue() == this.pred.getValue()) continue;
                    ++countPred;
                }
                if (countPred == rl.predicateSet.size()) {
                    int countDifPred = 0;
                    ArrayList<Predicates> predicSetTemp = new ArrayList<Predicates>();
                    for (int x = 0; x < rl.predicateSet.size(); ++x) {
                        predicSetTemp.add(rl.predicateSet.get(x));
                    }
                    predicSetTemp.add(this.pred);
                    for (int f = 0; f < this.ruleSet.size(); ++f) {
                        int countDifPredTemp = 0;
                        if (this.ruleSet.get((int)f).predicateSet.size() == predicSetTemp.size()) {
                            for (int x = 0; x < this.ruleSet.get((int)f).predicateSet.size(); ++x) {
                                if (this.ruleSet.get((int)f).predicateSet.get(x).getAttributeValue() != ((Predicates)predicSetTemp.get(x)).getAttributeValue() || this.ruleSet.get((int)f).predicateSet.get(x).getSymbol() != ((Predicates)predicSetTemp.get(x)).getSymbol() || this.ruleSet.get((int)f).predicateSet.get(x).getValue() != ((Predicates)predicSetTemp.get(x)).getValue()) continue;
                                ++countDifPredTemp;
                            }
                            if (countDifPredTemp == predicSetTemp.size()) break;
                            ++countDifPred;
                            continue;
                        }
                        ++countDifPred;
                    }
                    if (countDifPred == this.ruleSet.size()) {
                        int f;
                        int countIqualPred;
                        if (this.pred.getSymbol() == 1.0) {
                            countIqualPred = 0;
                            for (f = 0; f < rl.predicateSet.size(); ++f) {
                                if (this.pred.getAttributeValue() != rl.predicateSet.get(f).getAttributeValue() || this.pred.getSymbol() != rl.predicateSet.get(f).getSymbol()) continue;
                                ++countIqualPred;
                                if (!(this.pred.getValue() > rl.predicateSet.get(f).getValue())) continue;
                                rl.predicateSet.remove(f);
                                this.AddPredUpdateRuleStatistics(rl, ruleIndex, targetValorTotal, contaTargetValorTotal);
                            }
                            if (countIqualPred == 0) {
                                this.AddPredUpdateRuleStatistics(rl, ruleIndex, targetValorTotal, contaTargetValorTotal);
                            }
                        } else {
                            countIqualPred = 0;
                            for (f = 0; f < rl.predicateSet.size(); ++f) {
                                if (this.pred.getAttributeValue() != rl.predicateSet.get(f).getAttributeValue() || this.pred.getSymbol() != rl.predicateSet.get(f).getSymbol()) continue;
                                ++countIqualPred;
                                if (!(this.pred.getValue() < rl.predicateSet.get(f).getValue())) continue;
                                rl.predicateSet.remove(f);
                                this.AddPredUpdateRuleStatistics(rl, ruleIndex, targetValorTotal, contaTargetValorTotal);
                            }
                            if (countIqualPred == 0) {
                                this.AddPredUpdateRuleStatistics(rl, ruleIndex, targetValorTotal, contaTargetValorTotal);
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean PageHinckleyTest(double error, double threshold, Rule rl) {
        rl.PHmT += error;
        if (rl.PHmT < rl.PHMT) {
            rl.PHMT = rl.PHmT;
        }
        return rl.PHmT - rl.PHMT > threshold;
    }

    public void expandeRule(Rule rl, Instance inst) {
    }

    protected void ruleTargetData(Instance inst, int ruleIndex) {
        double target = this.targetValue.get(ruleIndex) + inst.classValue();
        double targetCount = this.numTargetValue.get(ruleIndex) + 1.0;
        this.targetValue.set(ruleIndex, target);
        this.numTargetValue.set(ruleIndex, targetCount);
    }

    protected void getRuleTarget(double sum, double count, int index) {
        double value = sum / count;
        this.ruleTargetMean.add(value);
    }

    protected void setRuleTarget(double sum, double count, int index) {
        double value = sum / count;
        this.ruleTargetMean.set(index, value);
    }

    public void initialyPerceptron(Instance inst) {
        if (this.resetDefault) {
            this.resetDefault = false;
            this.weightAttributeDefault = new double[inst.numAttributes()];
            this.instancesSeenDefault = 0;
            this.actualClassStatisticsDefault = 0.0;
            this.squaredActualClassStatisticsDefault = 0.0;
            this.attributeStatisticsDefault = new DoubleVector();
            this.squaredAttributeStatisticsDefault = new DoubleVector();
            this.attributesProbabilityDefault = new DoubleVector();
            Random r = new Random();
            long value = (long)this.seedOption.getValue();
            r.setSeed(value);
            for (int j = 0; j < inst.numAttributes(); ++j) {
                this.weightAttributeDefault[j] = 2.0 * r.nextDouble() - 1.0;
            }
        }
    }

    public void updatedefaultRuleStatistics(Instance inst) {
        ++this.instancesSeenDefault;
        for (int j = 0; j < inst.numAttributes() - 1; ++j) {
            this.attributeStatisticsDefault.addToValue(j, inst.value(j));
            this.squaredAttributeStatisticsDefault.addToValue(j, inst.value(j) * inst.value(j));
        }
        this.actualClassStatisticsDefault += inst.classValue();
        this.squaredActualClassStatisticsDefault += inst.classValue() * inst.classValue();
    }

    public void createRule(Instance inst) {
        int remainder = Integer.MAX_VALUE;
        int numInstanciaObservers = this.observersNumberInstance(inst, this.attributeObservers);
        if (numInstanciaObservers != 0 && this.gracePeriodOption.getValue() != 0) {
            remainder = numInstanciaObservers % this.gracePeriodOption.getValue();
        }
        if (remainder == 0) {
            this.theBestAttributes(inst, this.attributeObservers);
            boolean bestAttribute = this.checkBestAttrib(numInstanciaObservers);
            if (bestAttribute) {
                double attributeValue = this.saveTheBest.get(3);
                double symbol = this.saveTheBest.get(2);
                double value = this.saveTheBest.get(0);
                double targetValorTotal = this.saveTheBest.get(4);
                double contaTargetValorTotal = this.saveTheBest.get(5);
                this.pred = new Predicates(attributeValue, symbol, value);
                Rule Rl = new Rule();
                Rl.predicateSet.add(this.pred);
                Rl.weightAttribute = new double[inst.numAttributes()];
                System.arraycopy(this.weightAttributeDefault, 0, Rl.weightAttribute, 0, this.weightAttributeDefault.length);
                this.reanicializeRuleStatistic(Rl);
                this.ruleSet.add(Rl);
                this.targetValue.add(targetValorTotal);
                this.numTargetValue.add(contaTargetValorTotal);
                this.getRuleTarget(this.targetValue.get(this.ruleSet.size() - 1), this.numTargetValue.get(this.ruleSet.size() - 1), this.ruleSet.size() - 1);
                Rl.ValorTargetRule = this.ruleTargetMean.get(this.ruleSet.size() - 1);
                this.attributeObservers = new AutoExpandVector();
            }
        }
    }

    protected double observersDistrib(Instance inst, AutoExpandVector<AttributeClassObserver> observerss) {
        double votes = 0.0;
        for (int z = 0; z < inst.numAttributes() - 1; ++z) {
            BinaryTreeNumericAttributeClassObserverRegression.Node rootNode;
            int instAttIndex = AMRules.modelAttIndexToInstanceAttIndex(z, inst);
            if (!inst.attribute(instAttIndex).isNumeric() || observerss.get(z) == null || (rootNode = ((BinaryTreeNumericAttributeClassObserverRegression)observerss.get((int)z)).root1) == null) continue;
            double sum = rootNode.greaterThan[0] + rootNode.lessThan[0];
            double numTarget = rootNode.greaterThan[2] + rootNode.lessThan[2];
            votes = sum / numTarget;
            break;
        }
        return votes;
    }

    protected double getVotesUnorderedRulesTargetMean(Instance inst) {
        double votes = 0.0;
        double sum = 0.0;
        boolean fired = false;
        int countFired = 0;
        int count = 0;
        for (int j = 0; j < this.ruleSet.size(); ++j) {
            if (!this.ruleSet.get(j).ruleEvaluate(inst)) continue;
            ++countFired;
            double value = this.ruleSet.get((int)j).ValorTargetRule;
            sum += value;
            ++count;
        }
        if (countFired > 0) {
            fired = true;
            votes = sum / (double)count;
        } else {
            fired = false;
        }
        if (!fired) {
            votes = this.observersDistrib(inst, this.attributeObservers);
        }
        return votes;
    }

    protected double getVotesOrderedRulesTargetMean(Instance inst) {
        double votes = 0.0;
        boolean fired = false;
        int countFired = 0;
        for (int j = 0; j < this.ruleSet.size(); ++j) {
            double value;
            if (!this.ruleSet.get(j).ruleEvaluate(inst)) continue;
            ++countFired;
            votes = value = this.ruleSet.get((int)j).ValorTargetRule;
            break;
        }
        if (!(fired = countFired > 0)) {
            votes = this.observersDistrib(inst, this.attributeObservers);
        }
        return votes;
    }

    protected double getVotesUnorderedRulesPerceptron(Instance inst) {
        double votes = 0.0;
        double sum = 0.0;
        boolean fired = false;
        int countFired = 0;
        int count = 0;
        for (int j = 0; j < this.ruleSet.size(); ++j) {
            if (!this.ruleSet.get(j).ruleEvaluate(inst)) continue;
            ++countFired;
            double value = this.prediction(inst, this.ruleSet.get((int)j).weightAttribute, this.ruleSet.get((int)j).squaredActualClassStatistics, this.ruleSet.get((int)j).actualClassStatistics, this.ruleSet.get((int)j).instancesSeen, this.ruleSet.get((int)j).reset);
            sum += value;
            ++count;
        }
        if (countFired > 0) {
            fired = true;
            votes = sum / (double)count;
        } else {
            fired = false;
        }
        if (!fired) {
            votes = this.prediction(inst, this.weightAttributeDefault, this.squaredActualClassStatisticsDefault, this.actualClassStatisticsDefault, this.instancesSeenDefault, this.resetDefault);
        }
        return votes;
    }

    protected double getVotesOrderedRulesPerceptron(Instance inst) {
        double votes = 0.0;
        boolean fired = false;
        int countFired = 0;
        for (int j = 0; j < this.ruleSet.size(); ++j) {
            double value;
            if (!this.ruleSet.get(j).ruleEvaluate(inst)) continue;
            ++countFired;
            votes = value = this.prediction(inst, this.ruleSet.get((int)j).weightAttribute, this.ruleSet.get((int)j).squaredActualClassStatistics, this.ruleSet.get((int)j).actualClassStatistics, this.ruleSet.get((int)j).instancesSeen, this.ruleSet.get((int)j).reset);
            break;
        }
        if (!(fired = countFired > 0)) {
            votes = this.prediction(inst, this.weightAttributeDefault, this.squaredActualClassStatisticsDefault, this.actualClassStatisticsDefault, this.instancesSeenDefault, this.resetDefault);
        }
        return votes;
    }

    protected AttributeClassObserver newNominalClassObserver() {
        return new NominalAttributeClassObserver();
    }

    protected AttributeClassObserver newNumericClassObserver() {
        return new BinaryTreeNumericAttributeClassObserver();
    }

    protected AttributeClassObserver newNumericClassObserverRegression() {
        return new BinaryTreeNumericAttributeClassObserverRegression();
    }

    protected BigDecimal round(double val) {
        BigDecimal value = new BigDecimal(val);
        if (val != 0.0) {
            value = value.setScale(3, 1);
        }
        return value;
    }

    protected BigDecimal roundValue(double val) {
        BigDecimal value = new BigDecimal(val);
        if (val != 0.0) {
            value = value.setScale(0, 1);
        }
        return value;
    }
}

