/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.AbstractC;

import java.util.Vector;
import moa.clusterers.outliers.AbstractC.AbstractCBase;
import moa.clusterers.outliers.AbstractC.ISBIndex;
import moa.clusterers.outliers.AbstractC.StreamObj;
import moa.options.FlagOption;
import moa.options.FloatOption;
import moa.options.IntOption;
import weka.core.Instance;

public class AbstractC
extends AbstractCBase {
    public FloatOption radiusOption = new FloatOption("radius", 'r', "Search radius.", 0.1);
    public IntOption kOption = new IntOption("k", 't', "Parameter k.", 50);
    public FlagOption waitWinFullOption = new FlagOption("waitWinFull", 'a', "Output outliers when windows is full.");

    @Override
    public void Init() {
        super.Init();
        this.m_WindowSize = this.windowSizeOption.getValue();
        this.m_radius = this.radiusOption.getValue();
        this.m_Fraction = (double)this.kOption.getValue() / (double)this.m_WindowSize;
        this.Println("Init AbstractC:");
        this.Println("   window_size: " + this.m_WindowSize);
        this.Println("   radius: " + this.m_radius);
        this.Println("   Fraction: " + this.m_Fraction);
        this.Println("   (Fraction * window_size: " + String.format("%.2f", this.m_Fraction * (double)this.m_WindowSize) + ")");
        this.bWarning = true;
        this.objId = FIRST_OBJ_ID;
        this.windowNodes = new Vector();
        this.ISB = new ISBIndex(this.m_radius, this.m_Fraction);
        this.m_nBothInlierOutlier = 0;
        this.m_nOnlyInlier = 0;
        this.m_nOnlyOutlier = 0;
    }

    void UpdateNeighbors(ISBIndex.ISBNode n, ISBIndex.ISBNode q) {
        if (n == q) {
            return;
        }
        if (this.bTrace) {
            this.Println("UpdateNeighbors: n.id: " + n.id + ", q.id: " + q.id);
        }
        int len = q.lt_cnt.size();
        for (int i = 0; i < len; ++i) {
            n.lt_cnt.set(i, n.lt_cnt.get(i) + 1);
            q.lt_cnt.set(i, q.lt_cnt.get(i) + 1);
        }
    }

    void OutputPatterns() {
        if (this.bTrace) {
            this.Println("OutputPatterns");
        }
        double thr = this.m_Fraction * (double)this.m_WindowSize;
        for (ISBIndex.ISBNode node : this.windowNodes) {
            if (node.lt_cnt.size() > 0) {
                if (this.IsWinFull() || !this.waitWinFullOption.isSet()) {
                    if ((double)node.lt_cnt.get(0).intValue() < thr) {
                        this.SaveOutlier(node);
                    } else {
                        this.RemoveOutlier(node);
                    }
                }
                node.lt_cnt.remove(0);
                continue;
            }
            if (!this.bWarning) continue;
            this.Println("OutputPatterns: " + node.id + ".lt_cnt is empty!");
        }
    }

    @Override
    protected void ProcessNewStreamObj(Instance inst) {
        if (this.bShowProgress) {
            this.ShowProgress("Processed " + (this.objId - 1L) + " stream objects.");
        }
        double[] values = this.getInstanceValues(inst);
        StreamObj obj = new StreamObj(values);
        if (this.bTrace) {
            this.Println("\n- - - - - - - - - - - -\n");
        }
        ISBIndex.ISBNode nodeNew = new ISBIndex.ISBNode(inst, obj, this.objId);
        if (this.bTrace) {
            this.Print("New node: ");
            this.PrintNode(nodeNew);
        }
        Long l = this.objId;
        Long l2 = this.objId = Long.valueOf(this.objId + 1L);
        ISBIndex.ISBNode nodeExpired = this.GetExpiredNode();
        if (nodeExpired != null) {
            if (this.bTrace) {
                this.Print("nodeExpired: ");
                this.PrintNode(nodeExpired);
            }
            this.RemoveNode(nodeExpired);
        }
        if (this.bTrace) {
            this.Println("initialize nodeNew");
        }
        for (int i = 0; i < this.m_WindowSize; ++i) {
            nodeNew.lt_cnt.add(1);
        }
        this.AddNode(nodeNew);
        if (this.bTrace) {
            this.PrintWindow();
        }
        if (this.bTrace) {
            this.Println("Perform range query seach");
        }
        ++this.nRangeQueriesExecuted;
        Vector<ISBIndex.ISBSearchResult> neighbors = this.ISB.RangeSearch(nodeNew, this.m_radius);
        for (ISBIndex.ISBSearchResult res : neighbors) {
            ISBIndex.ISBNode node = res.node;
            this.UpdateNeighbors(nodeNew, node);
        }
        this.OutputPatterns();
        if (this.bTrace) {
            this.PrintOutliers();
            for (ISBIndex.ISBNode node : this.windowNodes) {
                this.Print(node.id + ".lt_count: ");
                this.Print_lt_cnt(node.lt_cnt);
            }
        }
    }
}

