/*
 * Decompiled with CFR 0.152.
 */
package moa.core;

import moa.AbstractMOAObject;
import weka.core.Statistics;

public class GaussianEstimator
extends AbstractMOAObject {
    private static final long serialVersionUID = 1L;
    protected double weightSum;
    protected double mean;
    protected double varianceSum;
    public static final double NORMAL_CONSTANT = Math.sqrt(Math.PI * 2);

    public void addObservation(double value, double weight) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            return;
        }
        if (this.weightSum > 0.0) {
            this.weightSum += weight;
            double lastMean = this.mean;
            this.mean += weight * (value - lastMean) / this.weightSum;
            this.varianceSum += weight * (value - lastMean) * (value - this.mean);
        } else {
            this.mean = value;
            this.weightSum = weight;
        }
    }

    public void addObservations(GaussianEstimator obs) {
        if (this.weightSum > 0.0 && obs.weightSum > 0.0) {
            double oldMean = this.mean;
            this.mean = this.mean * (this.weightSum / (this.weightSum + obs.weightSum)) + obs.mean * (obs.weightSum / (this.weightSum + obs.weightSum));
            this.varianceSum += obs.varianceSum + this.weightSum * obs.weightSum / (this.weightSum + obs.weightSum) * Math.pow(obs.mean - oldMean, 2.0);
            this.weightSum += obs.weightSum;
        }
    }

    public double getTotalWeightObserved() {
        return this.weightSum;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStdDev() {
        return Math.sqrt(this.getVariance());
    }

    public double getVariance() {
        return this.weightSum > 1.0 ? this.varianceSum / (this.weightSum - 1.0) : 0.0;
    }

    public double probabilityDensity(double value) {
        if (this.weightSum > 0.0) {
            double stdDev = this.getStdDev();
            if (stdDev > 0.0) {
                double diff = value - this.getMean();
                return 1.0 / (NORMAL_CONSTANT * stdDev) * Math.exp(-(diff * diff / (2.0 * stdDev * stdDev)));
            }
            return value == this.getMean() ? 1.0 : 0.0;
        }
        return 0.0;
    }

    public double[] estimatedWeight_LessThan_EqualTo_GreaterThan_Value(double value) {
        double stdDev;
        double lessThanWeight;
        double equalToWeight = this.probabilityDensity(value) * this.weightSum;
        double greaterThanWeight = this.weightSum - equalToWeight - (lessThanWeight = (stdDev = this.getStdDev()) > 0.0 ? Statistics.normalProbability((double)((value - this.getMean()) / stdDev)) * this.weightSum - equalToWeight : (value < this.getMean() ? this.weightSum - equalToWeight : 0.0));
        if (greaterThanWeight < 0.0) {
            greaterThanWeight = 0.0;
        }
        return new double[]{lessThanWeight, equalToWeight, greaterThanWeight};
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

