/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import moa.core.StringUtils;
import moa.gui.TaskTextViewerPanel;
import moa.tasks.ResultPreviewListener;
import moa.tasks.TaskThread;

public class PreviewPanel
extends JPanel
implements ResultPreviewListener {
    private static final long serialVersionUID = 1L;
    public static final String[] autoFreqStrings = new String[]{"never", "every second", "every 5 seconds", "every 10 seconds", "every 30 seconds", "every minute"};
    public static final int[] autoFreqTimeSecs = new int[]{0, 1, 5, 10, 30, 60};
    protected TaskThread previewedThread;
    protected JLabel previewLabel = new JLabel("No preview available");
    protected JButton refreshButton = new JButton("Refresh");
    protected JLabel autoRefreshLabel = new JLabel("Auto refresh: ");
    protected JComboBox autoRefreshComboBox = new JComboBox<String>(autoFreqStrings);
    protected TaskTextViewerPanel textViewerPanel;
    protected Timer autoRefreshTimer;
    protected boolean isRegression;

    public PreviewPanel() {
        this(false);
    }

    public PreviewPanel(boolean isRegression) {
        this.isRegression = isRegression;
        this.textViewerPanel = new TaskTextViewerPanel(isRegression);
        this.autoRefreshComboBox.setSelectedIndex(1);
        JPanel controlPanel = new JPanel();
        controlPanel.add(this.previewLabel);
        controlPanel.add(this.refreshButton);
        controlPanel.add(this.autoRefreshLabel);
        controlPanel.add(this.autoRefreshComboBox);
        this.setLayout(new BorderLayout());
        this.add((Component)controlPanel, "North");
        this.add((Component)this.textViewerPanel, "Center");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PreviewPanel.this.refresh();
            }
        });
        this.autoRefreshTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.refresh();
            }
        });
        this.autoRefreshComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PreviewPanel.this.updateAutoRefreshTimer();
            }
        });
        this.setTaskThreadToPreview(null);
    }

    public void refresh() {
        if (this.previewedThread != null) {
            if (this.previewedThread.isComplete()) {
                this.setLatestPreview(null);
                this.disableRefresh();
            } else {
                this.previewedThread.getPreview(this);
            }
        }
    }

    public void setTaskThreadToPreview(TaskThread thread) {
        this.previewedThread = thread;
        this.setLatestPreview(thread != null ? thread.getLatestResultPreview() : null);
        if (thread == null) {
            this.disableRefresh();
        } else if (!thread.isComplete()) {
            this.enableRefresh();
        }
    }

    public void setLatestPreview(Object preview) {
        if (this.previewedThread != null && this.previewedThread.isComplete()) {
            this.previewLabel.setText("Final result");
            Object finalResult = this.previewedThread.getFinalResult();
            this.textViewerPanel.setText(finalResult != null ? finalResult.toString() : null);
            this.disableRefresh();
        } else {
            double grabTime = this.previewedThread != null ? this.previewedThread.getLatestPreviewGrabTimeSeconds() : 0.0;
            String grabString = grabTime > 0.0 ? " (" + StringUtils.secondsToDHMSString(grabTime) + ")" : "";
            this.textViewerPanel.setText(preview != null ? preview.toString() : null);
            if (preview == null) {
                this.previewLabel.setText("No preview available" + grabString);
            } else {
                this.previewLabel.setText("Preview" + grabString);
            }
        }
    }

    public void updateAutoRefreshTimer() {
        int autoDelay = autoFreqTimeSecs[this.autoRefreshComboBox.getSelectedIndex()];
        if (autoDelay > 0) {
            if (this.autoRefreshTimer.isRunning()) {
                this.autoRefreshTimer.stop();
            }
            this.autoRefreshTimer.setDelay(autoDelay * 1000);
            this.autoRefreshTimer.start();
        } else {
            this.autoRefreshTimer.stop();
        }
    }

    public void disableRefresh() {
        this.refreshButton.setEnabled(false);
        this.autoRefreshLabel.setEnabled(false);
        this.autoRefreshComboBox.setEnabled(false);
        this.autoRefreshTimer.stop();
    }

    public void enableRefresh() {
        this.refreshButton.setEnabled(true);
        this.autoRefreshLabel.setEnabled(true);
        this.autoRefreshComboBox.setEnabled(true);
        this.updateAutoRefreshTimer();
    }

    @Override
    public void latestPreviewChanged() {
        this.setTaskThreadToPreview(this.previewedThread);
    }
}

