/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.clustering;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import moa.core.InputStreamProgressMonitor;
import moa.core.InstancesHeader;
import moa.core.ObjectRepository;
import moa.options.FileOption;
import moa.options.FlagOption;
import moa.options.IntOption;
import moa.options.ListOption;
import moa.options.Option;
import moa.streams.clustering.ClusteringStream;
import moa.tasks.TaskMonitor;
import weka.core.Instance;
import weka.core.Instances;

public class FileStream
extends ClusteringStream {
    private static final long serialVersionUID = 1L;
    String defaultfile = "/Users/kokomo40/Dropbox/BT Kim/Datasets/KDDCUP99/KDDCup99.arff";
    public FileOption arffFileOption = new FileOption("arffFile", 'f', "ARFF file to load.", this.defaultfile, "arff", false);
    public IntOption classIndexOption = new IntOption("classIndex", 'c', "Class index of data. 0 for none or -1 for last attribute in file.", -1, -1, Integer.MAX_VALUE);
    public FlagOption normalizeOption = new FlagOption("normalize", 'n', "Numerical data will be normalized to 0-1 for the visualization to work. The complete arff file needs to be read upfront.");
    public ListOption removeAttributesOption = new ListOption("removeAttributes", 'r', "Attributes to remove. Enter comma seperated list, starting with 1 for first attribute.", new IntOption("removeAttribute", ' ', "Attribute to remove.", -1), new Option[0], ',');
    public FlagOption keepNonNumericalAttrOption = new FlagOption("keepNonNumericalAttr", 'K', "Non-numerical attributes are being filtered by default (except the class attribute). Check to keep all attributes. This option is being overwritten by the manual attribute removal filter.");
    protected Instances instances;
    protected Reader fileReader;
    protected boolean hitEndOfFile;
    protected Instance lastInstanceRead;
    protected int numInstancesRead;
    protected InputStreamProgressMonitor fileProgressMonitor;
    private Integer[] removeAttributes = null;
    private Instances filteredDataset = null;
    private ArrayList<Double[]> valuesMinMaxDiff = null;

    @Override
    public String getPurposeString() {
        return "A stream read from an ARFF file. HINT: Visualization only works correctly with numerical 0-1 normalized attributes!";
    }

    public FileStream() {
        this.numAttsOption = null;
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        this.restart();
    }

    @Override
    public InstancesHeader getHeader() {
        return new InstancesHeader(this.filteredDataset);
    }

    @Override
    public long estimatedRemainingInstances() {
        double progressFraction = this.fileProgressMonitor.getProgressFraction();
        if (progressFraction > 0.0 && this.numInstancesRead > 0) {
            return (long)((double)this.numInstancesRead / progressFraction - (double)this.numInstancesRead);
        }
        return -1L;
    }

    @Override
    public boolean hasMoreInstances() {
        return !this.hitEndOfFile;
    }

    @Override
    public Instance nextInstance() {
        Instance prevInstance = this.lastInstanceRead;
        this.hitEndOfFile = !this.readNextInstanceFromFile();
        return prevInstance;
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public void restart() {
        try {
            int i;
            if (this.fileReader != null) {
                this.fileReader.close();
            }
            FileInputStream fileStream = new FileInputStream(this.arffFileOption.getFile());
            this.fileProgressMonitor = new InputStreamProgressMonitor(fileStream);
            this.fileReader = new BufferedReader(new InputStreamReader(this.fileProgressMonitor));
            this.instances = new Instances(this.fileReader, 1);
            if (this.classIndexOption.getValue() < 0) {
                this.instances.setClassIndex(this.instances.numAttributes() - 1);
            } else if (this.classIndexOption.getValue() > 0) {
                this.instances.setClassIndex(this.classIndexOption.getValue() - 1);
            }
            HashSet<Integer> attributes = new HashSet<Integer>();
            Option[] rawAttributeList = this.removeAttributesOption.getList();
            for (i = 0; i < rawAttributeList.length; ++i) {
                int attribute = ((IntOption)rawAttributeList[i]).getValue();
                if (1 <= attribute && attribute <= this.instances.numAttributes()) {
                    attributes.add(attribute - 1);
                    continue;
                }
                System.out.println("Found invalid attribute removal description: Attribute option " + attribute + " will be ignored. Filestream only has " + this.instances.numAttributes() + " attributes.");
            }
            if (!this.keepNonNumericalAttrOption.isSet()) {
                for (i = 0; i < this.instances.numAttributes(); ++i) {
                    if (this.instances.attribute(i).isNumeric() || i == this.instances.classIndex()) continue;
                    attributes.add(i);
                }
            }
            if (this.normalizeOption.isSet()) {
                this.valuesMinMaxDiff = this.readMinMaxDiffValues(attributes);
            }
            this.removeAttributes = attributes.toArray(new Integer[0]);
            Arrays.sort((Object[])this.removeAttributes);
            this.numAttsOption = new IntOption("numAtts", 'a', "", this.instances.numAttributes() - this.removeAttributes.length);
            if (this.removeAttributes.length > 0) {
                System.out.println("Removing the following attributes:");
                for (i = 0; i < this.removeAttributes.length; ++i) {
                    System.out.println(this.removeAttributes[i] + 1 + " " + this.instances.attribute(this.removeAttributes[i].intValue()).name());
                }
            }
            this.filteredDataset = new Instances(this.instances);
            for (i = this.removeAttributes.length - 1; i >= 0; --i) {
                this.filteredDataset.deleteAttributeAt(this.removeAttributes[i].intValue());
            }
            this.numInstancesRead = 0;
            this.lastInstanceRead = null;
            this.hitEndOfFile = !this.readNextInstanceFromFile();
        }
        catch (IOException ioe) {
            throw new RuntimeException("ArffFileStream restart failed.", ioe);
        }
    }

    protected boolean readNextInstanceFromFile() {
        try {
            if (this.instances.readInstance(this.fileReader)) {
                int i;
                Instance rawInstance = this.instances.instance(0);
                rawInstance.setDataset(null);
                for (i = this.removeAttributes.length - 1; i >= 0; --i) {
                    rawInstance.deleteAttributeAt(this.removeAttributes[i].intValue());
                }
                rawInstance.setDataset(this.filteredDataset);
                if (this.normalizeOption.isSet() && this.valuesMinMaxDiff != null) {
                    for (i = 0; i < rawInstance.numAttributes(); ++i) {
                        if (this.valuesMinMaxDiff.get(i)[2] == 1.0 || this.valuesMinMaxDiff.get(i)[2] == 0.0 || i == rawInstance.classIndex()) continue;
                        double v = rawInstance.value(i);
                        v = (v - this.valuesMinMaxDiff.get(i)[0]) / this.valuesMinMaxDiff.get(i)[2];
                        rawInstance.setValue(i, v);
                    }
                }
                this.lastInstanceRead = rawInstance;
                this.instances.delete();
                ++this.numInstancesRead;
                return true;
            }
            if (this.fileReader != null) {
                this.fileReader.close();
                this.fileReader = null;
            }
            return false;
        }
        catch (IOException ioe) {
            throw new RuntimeException("ArffFileStream failed to read instance from stream.", ioe);
        }
    }

    protected ArrayList<Double[]> readMinMaxDiffValues(HashSet<Integer> ignoredAttributes) {
        ArrayList<Double[]> valuesMinMaxDiff = null;
        if (ignoredAttributes == null) {
            ignoredAttributes = new HashSet();
        }
        try {
            FileInputStream fileStream = new FileInputStream(this.arffFileOption.getFile());
            InputStreamProgressMonitor fileProgressMonitor = new InputStreamProgressMonitor(fileStream);
            BufferedReader fileReader = new BufferedReader(new InputStreamReader(fileProgressMonitor));
            Instances instances = new Instances((Reader)fileReader, 1);
            valuesMinMaxDiff = new ArrayList<Double[]>();
            for (int i = 0; i < instances.numAttributes() - ignoredAttributes.size(); ++i) {
                Double[] values = new Double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0};
                valuesMinMaxDiff.add(values);
            }
            System.out.print("Reading arff file for normalization...");
            int counter = 0;
            while (instances.readInstance((Reader)fileReader)) {
                Instance instance = instances.instance(0);
                int a = 0;
                for (int i = 0; i < instances.numAttributes(); ++i) {
                    if (ignoredAttributes.contains(i)) continue;
                    double value = instance.value(i);
                    if (value < valuesMinMaxDiff.get(a)[0]) {
                        valuesMinMaxDiff.get((int)a)[0] = value;
                    }
                    if (value > valuesMinMaxDiff.get(a)[1]) {
                        valuesMinMaxDiff.get((int)a)[1] = value;
                    }
                    ++a;
                }
                instances.delete();
                if (++counter < 10000) continue;
                counter = 0;
                System.out.print(".");
            }
            if (fileReader != null) {
                ((Reader)fileReader).close();
                fileReader = null;
            }
            System.out.println("done!");
            for (int i = 0; i < valuesMinMaxDiff.size(); ++i) {
                valuesMinMaxDiff.get((int)i)[2] = valuesMinMaxDiff.get(i)[1] - valuesMinMaxDiff.get(i)[0];
            }
            return valuesMinMaxDiff;
        }
        catch (IOException ioe) {
            throw new RuntimeException("ArffFileStream failed to read instance from stream.", ioe);
        }
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

