/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.QuickInfoHelper;
import adams.core.Variables;
import adams.core.option.OptionHandler;
import adams.event.VariableChangeListener;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.CallableActorUser;
import adams.flow.core.ErrorHandler;
import java.util.HashSet;

public abstract class AbstractCopyCallableActor
extends AbstractActor
implements CallableActorUser {
    private static final long serialVersionUID = -7860206690560690212L;
    protected CallableActorReference m_CallableName;
    protected AbstractActor m_CallableActor;
    protected CallableActorHelper m_Helper;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("callable", "callableName", (Object)new CallableActorReference("unknown"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    public void setCallableName(CallableActorReference value) {
        this.m_CallableName = value;
        this.reset();
    }

    public CallableActorReference getCallableName() {
        return this.m_CallableName;
    }

    public String callableNameTipText() {
        return "The name of the callable actor to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"callableName", (Object)this.m_CallableName);
    }

    protected AbstractActor findCallableActor() {
        return this.m_Helper.findCallableActorRecursive((AbstractActor)this, this.getCallableName());
    }

    public boolean hasCallableActor() {
        return this.m_CallableActor != null;
    }

    public AbstractActor getCallableActor() {
        return this.m_CallableActor;
    }

    protected void forceVariables(Variables value) {
        super.forceVariables(value);
        if (this.m_CallableActor != null) {
            this.m_CallableActor.setVariables(value);
        }
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_CallableActor = this.findCallableActor();
            if (this.m_CallableActor == null) {
                result = "Couldn't find callable actor '" + this.getCallableName() + "'!";
            } else {
                this.m_CallableActor = this.m_CallableActor.shallowCopy();
                this.m_CallableActor.setParent(this.getParent());
                this.m_CallableActor.setVariables(this.getVariables());
                result = this.m_CallableActor.setUp();
                if (result == null) {
                    HashSet variables = this.findVariables(this.m_CallableActor);
                    this.m_DetectedVariables.addAll(variables);
                    if (this.m_DetectedVariables.size() > 0) {
                        this.getVariables().addVariableChangeListener((VariableChangeListener)this);
                    }
                    if (this.getErrorHandler() != this) {
                        ActorUtils.updateErrorHandler((Actor)this.m_CallableActor, (ErrorHandler)this.getErrorHandler());
                    }
                }
            }
        }
        return result;
    }

    protected abstract String executeCallableActor();

    protected String doExecute() {
        String result = null;
        if (!this.m_CallableActor.getSkip() && !this.m_CallableActor.isStopped()) {
            result = this.executeCallableActor();
        }
        return result;
    }

    public boolean isFinished() {
        if (this.m_CallableActor == null) {
            return true;
        }
        return this.m_CallableActor.isFinished();
    }

    public void stopExecution() {
        if (this.m_CallableActor != null) {
            this.m_CallableActor.stopExecution();
        }
        super.stopExecution();
    }

    public void wrapUp() {
        if (this.m_CallableActor != null) {
            this.m_CallableActor.wrapUp();
        }
        super.wrapUp();
    }

    public void cleanUp() {
        super.cleanUp();
        if (this.m_CallableActor != null) {
            this.m_CallableActor.cleanUp();
            this.m_CallableActor = null;
        }
    }
}

