/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.complex;

import org.ddogleg.complex.ComplexPolar64F;
import org.ejml.data.Complex64F;

public class ComplexMath {
    public static void plus(Complex64F a, Complex64F b, Complex64F result) {
        result.real = a.real + b.real;
        result.imaginary = a.imaginary + b.imaginary;
    }

    public static void minus(Complex64F a, Complex64F b, Complex64F result) {
        result.real = a.real - b.real;
        result.imaginary = a.imaginary - b.imaginary;
    }

    public static void mult(Complex64F a, Complex64F b, Complex64F result) {
        result.real = a.real * b.real - a.imaginary * b.imaginary;
        result.imaginary = a.real * b.imaginary + a.imaginary * b.real;
    }

    public static void div(Complex64F a, Complex64F b, Complex64F result) {
        double norm = b.getMagnitude2();
        result.real = (a.real * b.real + a.imaginary * b.imaginary) / norm;
        result.imaginary = (a.imaginary * b.real - a.real * b.imaginary) / norm;
    }

    public static void convert(Complex64F input, ComplexPolar64F output) {
        output.r = input.getMagnitude();
        output.theta = Math.atan2(input.imaginary, input.real);
    }

    public static void convert(ComplexPolar64F input, Complex64F output) {
        output.real = input.r * Math.cos(input.theta);
        output.imaginary = input.r * Math.sin(input.theta);
    }

    public static void mult(ComplexPolar64F a, ComplexPolar64F b, ComplexPolar64F result) {
        result.r = a.r * b.r;
        result.theta = a.theta + b.theta;
    }

    public static void div(ComplexPolar64F a, ComplexPolar64F b, ComplexPolar64F result) {
        result.r = a.r / b.r;
        result.theta = a.theta - b.theta;
    }

    public static void pow(ComplexPolar64F a, int N, ComplexPolar64F result) {
        result.r = Math.pow(a.r, N);
        result.theta = (double)N * a.theta;
    }

    public static void root(ComplexPolar64F a, int N, int k, ComplexPolar64F result) {
        result.r = Math.pow(a.r, 1.0 / (double)N);
        result.theta = (a.theta + 2.0 * (double)k * Math.PI) / (double)N;
    }

    public static void root(Complex64F a, int N, int k, Complex64F result) {
        double r = a.getMagnitude();
        double theta = Math.atan2(a.imaginary, a.real);
        r = Math.pow(r, 1.0 / (double)N);
        theta = (theta + 2.0 * (double)k * Math.PI) / (double)N;
        result.real = r * Math.cos(theta);
        result.imaginary = r * Math.sin(theta);
    }
}

