/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn;

import java.util.Random;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.alg.AxisSplitRuleRandomK;
import org.ddogleg.nn.alg.AxisSplitterMedian;
import org.ddogleg.nn.alg.KdTreeSearchBbf;
import org.ddogleg.nn.wrap.KdForestBbfSearch;
import org.ddogleg.nn.wrap.KdTreeNearestNeighbor;
import org.ddogleg.nn.wrap.WrapExhaustiveNeighbor;

public class FactoryNearestNeighbor {
    public static <D> NearestNeighbor<D> kdtree() {
        return new KdTreeNearestNeighbor();
    }

    public static <D> NearestNeighbor<D> kdtree(int maxNodesSearched) {
        return new KdTreeNearestNeighbor(new KdTreeSearchBbf(maxNodesSearched), new AxisSplitterMedian());
    }

    public static <D> NearestNeighbor<D> kdRandomForest(int maxNodesSearched, int numTrees, int numConsiderSplit, long randomSeed) {
        Random rand = new Random(randomSeed);
        return new KdForestBbfSearch(numTrees, maxNodesSearched, new AxisSplitterMedian(new AxisSplitRuleRandomK(rand, numConsiderSplit)));
    }

    public static <D> NearestNeighbor<D> exhaustive() {
        return new WrapExhaustiveNeighbor();
    }
}

