/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.wrap;

import java.util.List;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.AxisSplitter;
import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeConstructor;
import org.ddogleg.nn.alg.KdTreeMemory;
import org.ddogleg.nn.alg.KdTreeSearchBbf;

public class KdForestBbfSearch<D>
implements NearestNeighbor<D> {
    KdTree[] forest;
    KdTreeConstructor<D> constructor;
    KdTreeSearchBbf search;
    AxisSplitter<D> splitter;
    KdTreeMemory memory = new KdTreeMemory();

    public KdForestBbfSearch(int numberOfTrees, int maxNodesSearched, AxisSplitter<D> splitter) {
        this.forest = new KdTree[numberOfTrees];
        this.splitter = splitter;
        this.search = new KdTreeSearchBbf(maxNodesSearched);
    }

    @Override
    public void init(int pointDimension) {
        this.constructor = new KdTreeConstructor<D>(this.memory, pointDimension, this.splitter);
    }

    @Override
    public void setPoints(List<double[]> points, List<D> data) {
        int i;
        if (this.forest[0] != null) {
            for (i = 0; i < this.forest.length; ++i) {
                this.memory.recycleGraph(this.forest[i]);
            }
        }
        for (i = 0; i < this.forest.length; ++i) {
            this.forest[i] = this.constructor.construct(points, data);
        }
        this.search.setTrees(this.forest);
    }

    @Override
    public boolean findNearest(double[] point, double maxDistance, NnData<D> result) {
        if (maxDistance <= 0.0) {
            this.search.setMaxDistance(Double.MAX_VALUE);
        } else {
            this.search.setMaxDistance(maxDistance);
        }
        KdTree.Node found = this.search.findClosest(point);
        if (found == null) {
            return false;
        }
        result.point = found.point;
        result.data = found.data;
        result.distance = this.search.getDistance();
        return true;
    }
}

