/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.wrap;

import org.ddogleg.optimization.OptimizationException;
import org.ddogleg.optimization.UnconstrainedMinimization;
import org.ddogleg.optimization.functions.FunctionNtoN;
import org.ddogleg.optimization.functions.FunctionNtoS;
import org.ddogleg.optimization.functions.GradientLineFunction;
import org.ddogleg.optimization.impl.LineSearchMore94;
import org.ddogleg.optimization.impl.QuasiNewtonBFGS;
import org.ddogleg.optimization.wrap.CachedGradientLineFunction;
import org.ddogleg.optimization.wrap.CachedNumericalGradientLineFunction;

public class WrapQuasiNewtonBFGS
implements UnconstrainedMinimization {
    private static final double line_gtol = 0.9;
    private static final double line_ftol = 0.001;
    private static final double line_xtol = 0.1;
    QuasiNewtonBFGS alg;

    @Override
    public void setFunction(FunctionNtoS function, FunctionNtoN gradient, double minFunctionValue) {
        LineSearchMore94 lineSearch = new LineSearchMore94(0.001, 0.9, 0.1);
        GradientLineFunction gradLine = gradient == null ? new CachedNumericalGradientLineFunction(function) : new CachedGradientLineFunction(function, gradient);
        this.alg = new QuasiNewtonBFGS(gradLine, lineSearch, minFunctionValue);
    }

    @Override
    public void initialize(double[] initial, double ftol, double gtol) {
        this.alg.setConvergence(ftol, gtol, 0.9);
        this.alg.initialize(initial);
    }

    @Override
    public double[] getParameters() {
        return this.alg.getParameters();
    }

    @Override
    public boolean iterate() throws OptimizationException {
        return this.alg.iterate();
    }

    @Override
    public boolean isConverged() {
        return this.alg.isConverged();
    }

    @Override
    public String getWarning() {
        return this.alg.getWarning();
    }

    @Override
    public double getFunctionValue() {
        return this.alg.getFx();
    }

    @Override
    public boolean isUpdated() {
        return this.alg.isUpdatedParameters();
    }
}

