/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver;

import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.LinearSolver;
import org.ejml.factory.LinearSolverFactory;

public class FitQuadratic1D {
    LinearSolver<DenseMatrix64F> solver = LinearSolverFactory.leastSquares((int)10, (int)3);
    DenseMatrix64F A = new DenseMatrix64F(1, 3);
    DenseMatrix64F x = new DenseMatrix64F(3, 1);
    DenseMatrix64F y = new DenseMatrix64F(1, 1);

    public boolean process(int offset, int length, double ... data) {
        if (data.length < 3) {
            throw new IllegalArgumentException("At least three points");
        }
        this.A.reshape(data.length, 3);
        this.y.reshape(data.length, 1);
        int indexDst = 0;
        int indexSrc = offset;
        for (int i = 0; i < length; ++i) {
            double d = data[indexSrc++];
            this.A.data[indexDst++] = i * i;
            this.A.data[indexDst++] = i;
            this.A.data[indexDst++] = 1.0;
            this.y.data[i] = d;
        }
        if (!this.solver.setA((Matrix64F)this.A)) {
            return false;
        }
        this.solver.solve((Matrix64F)this.y, (Matrix64F)this.x);
        return true;
    }

    public double[] getCoefficients() {
        return this.x.data;
    }
}

