/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.core;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.timeseries.AbstractForecaster;
import weka.classifiers.timeseries.TSForecaster;
import weka.classifiers.timeseries.core.OverlayForecaster;
import weka.classifiers.timeseries.core.TSLagUser;
import weka.classifiers.timeseries.eval.ErrorModule;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class ErrorBasedConfidenceIntervalEstimator
implements Serializable {
    private static final long serialVersionUID = -2748314799535071043L;
    protected List<List<double[]>> m_confidenceLimitsForTargets;
    protected List<String> m_targetFields;
    protected double m_confidenceLevel;

    public List<double[]> getConfidenceOffsets(double confidenceLevel, List<List<NumericPrediction>> predictions) throws Exception {
        if (predictions == null || predictions.get(0).size() == 0) {
            throw new Exception("No predictions have been seen yet!");
        }
        ArrayList<double[]> result = new ArrayList<double[]>();
        for (int i = 0; i < this.m_targetFields.size(); ++i) {
            List<NumericPrediction> preds = predictions.get(i);
            ArrayList<Double> posErrs = new ArrayList<Double>();
            ArrayList<Double> negErrs = new ArrayList<Double>();
            for (NumericPrediction p : preds) {
                if (Utils.isMissingValue((double)p.error())) continue;
                if (p.error() < 0.0) {
                    negErrs.add(new Double(Math.abs(p.error())));
                }
                if (!(p.error() > 0.0)) continue;
                posErrs.add(new Double(p.error()));
            }
            Collections.sort(posErrs);
            Collections.sort(negErrs);
            double[] bounds = new double[]{Utils.missingValue(), Utils.missingValue()};
            if (posErrs.size() > 0 && negErrs.size() > 0) {
                int negPosition;
                double cL = 1.0 - confidenceLevel;
                int posPosition = (int)Math.round((double)posErrs.size() * cL);
                if (posPosition < 1) {
                    posPosition = 1;
                }
                if ((negPosition = (int)Math.round((double)negErrs.size() * cL)) < 1) {
                    negPosition = 1;
                }
                double upperBound = (Double)negErrs.get(negErrs.size() - negPosition);
                double lowerBound = (Double)posErrs.get(posErrs.size() - posPosition);
                bounds[0] = lowerBound = -lowerBound;
                bounds[1] = upperBound;
            }
            result.add(bounds);
        }
        return result;
    }

    protected Instances createOverlayForecastData(TSForecaster forecaster, Instances source, int start, int numSteps) {
        int toCopy = Math.min(numSteps, source.numInstances() - start);
        Instances overlay = new Instances(source, start, toCopy);
        List<String> fieldsToForecast = AbstractForecaster.stringToList(forecaster.getFieldsToForecast());
        for (int i = 0; i < overlay.numInstances(); ++i) {
            Instance current = overlay.instance(i);
            for (String target : fieldsToForecast) {
                current.setValue(overlay.attribute(target), Utils.missingValue());
            }
        }
        return overlay;
    }

    public void calculateConfidenceOffsets(TSForecaster forecaster, Instances insts, int numPrime, int numSteps, double confidenceLevel, PrintStream ... progress) throws Exception {
        this.calculateConfidenceOffsets(forecaster, insts, numPrime, -1, numSteps, confidenceLevel, progress);
    }

    public void calculateConfidenceOffsets(TSForecaster forecaster, Instances insts, int numPrime, int artificialTimeStartValue, int numSteps, double confidenceLevel, PrintStream ... progress) throws Exception {
        if (insts.numInstances() < numPrime + numSteps) {
            throw new Exception("We need at least " + (numPrime + numSteps) + " instances in order to calculate confidence limits!");
        }
        if (confidenceLevel < 0.0 || confidenceLevel > 1.0) {
            throw new Exception("Confidence level must lie between 0 and 1");
        }
        this.m_targetFields = AbstractForecaster.stringToList(forecaster.getFieldsToForecast());
        this.m_confidenceLevel = confidenceLevel;
        ArrayList<ErrorModule> confidenceCalculators = new ArrayList<ErrorModule>();
        for (int i = 0; i < numSteps; ++i) {
            ErrorModule m = new ErrorModule();
            m.setTargetFields(this.m_targetFields);
            confidenceCalculators.add(m);
        }
        Instances primeInsts = new Instances(insts, 0, numPrime);
        primeInsts.compactify();
        if (forecaster instanceof TSLagUser && artificialTimeStartValue >= 0) {
            ((TSLagUser)((Object)forecaster)).getTSLagMaker().setArtificialTimeStartValue(artificialTimeStartValue - 1 + numPrime);
        }
        for (int i = numPrime; i < insts.numInstances(); ++i) {
            forecaster.primeForecaster(primeInsts);
            if (i % 10 == 0) {
                for (PrintStream p : progress) {
                    p.println("Computing confidence intervals: processed " + i + " instances...");
                }
            }
            List<List<NumericPrediction>> forecastForSteps = null;
            if (forecaster instanceof OverlayForecaster && ((OverlayForecaster)((Object)forecaster)).isUsingOverlayData()) {
                Instances overlay = this.createOverlayForecastData(forecaster, insts, i, numSteps);
                forecastForSteps = ((OverlayForecaster)((Object)forecaster)).forecast(numSteps, overlay, new PrintStream[0]);
            } else {
                forecastForSteps = forecaster.forecast(numSteps, new PrintStream[0]);
            }
            for (int j = 0; j < numSteps && i + j < insts.numInstances(); ++j) {
                Instance toPredict = insts.instance(i + j);
                List<NumericPrediction> predsForTargets = forecastForSteps.get(j);
                ((ErrorModule)confidenceCalculators.get(j)).evaluateForInstance(predsForTargets, toPredict);
            }
            primeInsts.delete(0);
            primeInsts.add(insts.instance(i));
            primeInsts.compactify();
        }
        this.m_confidenceLimitsForTargets = new ArrayList<List<double[]>>();
        for (int j = 0; j < this.m_targetFields.size(); ++j) {
            ArrayList<double[]> limitsForSingleTarget = new ArrayList<double[]>();
            for (int i = 0; i < numSteps; ++i) {
                List<List<NumericPrediction>> predsForStepI = ((ErrorModule)confidenceCalculators.get(i)).getPredictionsForAllTargets();
                List<double[]> confOffsetsForStepI = this.getConfidenceOffsets(confidenceLevel, predsForStepI);
                double[] limitsAtStepI = confOffsetsForStepI.get(j);
                limitsForSingleTarget.add(limitsAtStepI);
            }
            this.m_confidenceLimitsForTargets.add(limitsForSingleTarget);
        }
    }

    public double getConfidenceLevel() {
        return this.m_confidenceLevel;
    }

    public double[] getConfidenceLimitsForTarget(String targetName, double targetValue, int stepNum) throws Exception {
        int index = this.m_targetFields.indexOf(targetName);
        if (index < 0) {
            throw new Exception("[ErrorBasedConfidenceLimitEstimator] unknown target: " + targetName);
        }
        List<double[]> confForTarget = this.m_confidenceLimitsForTargets.get(index);
        if (stepNum > confForTarget.size()) {
            throw new Exception("[ErrorBasedConfidenceLimitEstimator] no limits availalbe forrequested step number: " + stepNum);
        }
        double[] offsets = confForTarget.get(stepNum - 1);
        double[] limits = new double[]{targetValue + offsets[0], targetValue + offsets[1]};
        return limits;
    }
}

