/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.classifiers.timeseries.gui.ForecastingPanel;
import weka.core.Instances;
import weka.gui.beans.BeanInstance;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.TimeSeriesForecasting;

public class TimeSeriesForecastingKFPerspective
extends JPanel
implements KnowledgeFlowApp.KFPerspective {
    private static final long serialVersionUID = -2653395123580895862L;
    protected ForecastingPanel m_forecastingPanel;

    public TimeSeriesForecastingKFPerspective() {
        this.setLayout(new BorderLayout());
        this.m_forecastingPanel = new ForecastingPanel(null, false, false, true);
        this.add((Component)this.m_forecastingPanel, "Center");
    }

    public static void setClipboard(TimeSeriesForecasting component) throws Exception {
        StringBuffer serialized;
        BeanInstance beanI = new BeanInstance(null, (Object)component, 50, 50, new Integer[0]);
        beanI.removeBean(null, new Integer[0]);
        Vector<BeanInstance> beans = new Vector<BeanInstance>();
        beans.add(beanI);
        KnowledgeFlowApp singleton = KnowledgeFlowApp.getSingleton();
        singleton.m_pasteBuffer = serialized = singleton.copyToBuffer(beans);
        singleton.setActivePerspective(0);
        singleton.m_mainKFPerspective.setActiveTab(singleton.m_mainKFPerspective.getCurrentTabIndex());
    }

    public String getPerspectiveTitle() {
        return "Time series forecasting";
    }

    public String getPerspectiveTipText() {
        return "Time series forecasting environment";
    }

    public Icon getPerspectiveIcon() {
        Image pic = null;
        URL imageURL = this.getClass().getClassLoader().getResource("weka/gui/beans/icons/chart_line.png");
        if (imageURL != null) {
            pic = Toolkit.getDefaultToolkit().getImage(imageURL);
        }
        return new ImageIcon(pic);
    }

    public void setActive(boolean active) {
    }

    public void setLoaded(boolean loaded) {
    }

    public void setMainKFPerspective(KnowledgeFlowApp.MainKFPerspective main) {
    }

    public void setInstances(Instances inst) {
        if (this.m_forecastingPanel != null) {
            try {
                this.m_forecastingPanel.setInstances(inst);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean acceptsInstances() {
        return true;
    }

    public static void main(String[] args) {
        try {
            Instances insts = new Instances((Reader)new BufferedReader(new FileReader(args[0])));
            TimeSeriesForecastingKFPerspective p = new TimeSeriesForecastingKFPerspective();
            p.setInstances(insts);
            JFrame frame = new JFrame("Time series forecasting");
            frame.setSize(800, 600);
            frame.setContentPane(p);
            frame.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

