/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.Range;
import adams.core.Utils;
import adams.data.spreadsheet.SpreadSheetUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractDataBackedRange<T>
extends Range {
    private static final long serialVersionUID = 5215987200366396733L;
    protected T m_Data;
    protected List<String> m_Names;
    protected HashMap<String, Integer> m_Indices;
    protected transient Comparator m_Comparator;

    public AbstractDataBackedRange() {
    }

    public AbstractDataBackedRange(String range) {
        super(range);
    }

    public AbstractDataBackedRange(String range, int max) {
        super(range, max);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Data = null;
        this.m_Names = null;
        this.m_Indices = null;
        this.m_Comparator = null;
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Names = null;
        this.m_Indices = null;
    }

    public void setData(T value) {
        this.m_Data = value;
        if (this.m_Data == null) {
            this.setMax(-1);
        } else {
            this.setMax(this.getNumColumns(value));
        }
        this.reset();
    }

    public T getData() {
        return this.m_Data;
    }

    protected abstract int getNumColumns(T var1);

    protected abstract String getColumnName(T var1, int var2);

    protected abstract Comparator newComparator();

    protected synchronized Comparator getComparator() {
        if (this.m_Comparator == null) {
            this.m_Comparator = this.newComparator();
        }
        return this.m_Comparator;
    }

    protected synchronized void initLookUp() {
        if (this.m_Names == null) {
            ArrayList<String> names = new ArrayList<String>();
            HashMap<String, Integer> indices = new HashMap<String, Integer>();
            if (this.m_Data != null) {
                for (int i = 0; i < this.getNumColumns(this.m_Data); ++i) {
                    String name = this.getColumnName(this.m_Data, i);
                    name = AbstractDataBackedRange.escapeColumnName(name);
                    names.add(name);
                    indices.put(name, i);
                }
                Collections.sort(names, this.getComparator());
            }
            this.m_Names = names;
            this.m_Indices = indices;
        }
    }

    protected List<String> getNames() {
        this.initLookUp();
        return this.m_Names;
    }

    public HashMap<String, Integer> getIndices() {
        this.initLookUp();
        return this.m_Indices;
    }

    protected boolean isColumnName(String s) {
        boolean result = false;
        List<String> names = this.getNames();
        for (int i = 0; i < names.size(); ++i) {
            if (!s.equals(names.get(i))) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    protected List<String> getPlaceholders() {
        List<String> result = super.getPlaceholders();
        result.addAll(this.getNames());
        return result;
    }

    @Override
    protected boolean canReplaceInvalidChars() {
        return this.m_Data != null;
    }

    @Override
    protected String[] splitRange(String s) {
        return SpreadSheetUtils.split(s, "-".charAt(0));
    }

    @Override
    protected String[] splitList(String s) {
        return SpreadSheetUtils.split(s, ",".charAt(0));
    }

    @Override
    protected String removeInvalidChars(String s, List<String> valid) {
        Object[] list = this.splitList(s);
        for (int i = 0; i < list.length; ++i) {
            if (list[i].startsWith("\"")) continue;
            list[i] = super.removeInvalidChars(s, valid);
        }
        return Utils.flatten(list, ",");
    }

    @Override
    protected int parse(String s, int max) {
        if (this.isColumnName(s)) {
            return this.getIndices().get(s);
        }
        return super.parse(s, max);
    }

    public static String escapeColumnName(String col) {
        if (col.indexOf("-") > -1) {
            col = "\"" + col + "\"";
        } else if (col.indexOf(",") > -1) {
            col = "\"" + col + "\"";
        } else if (col.indexOf("_") > -1) {
            col = "\"" + col + "\"";
        }
        return col;
    }

    public static String unescapeColumnName(String col) {
        if (col.startsWith("\"") && col.endsWith("\"")) {
            return col.substring(1, col.length() - 1);
        }
        return col;
    }

    public static class InvertedStringLengthComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = -3821875620058964511L;

        @Override
        public int compare(String o1, String o2) {
            return -new Integer(o1.length()).compareTo(o2.length());
        }
    }
}

