/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.Properties;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import java.util.Enumeration;

public class NamedSetups {
    public static final String FILENAME = "NamedSetups.props";
    protected Properties m_Properties;
    protected static NamedSetups m_Singleton;

    private NamedSetups() {
        this.initialize();
    }

    protected void initialize() {
        if (this.m_Properties == null) {
            this.reload();
        }
    }

    public synchronized void reload() {
        try {
            this.m_Properties = Environment.getInstance().read("named setups");
        }
        catch (Exception e) {
            this.m_Properties = new Properties();
        }
    }

    public Enumeration<String> names() {
        return this.m_Properties.propertyNames();
    }

    public boolean has(String name) {
        return this.m_Properties.hasKey(name);
    }

    public Object get(String name) {
        return this.get(name, null);
    }

    public Object get(String name, Object defValue) {
        Object result = defValue;
        if (!name.equals("name_of_setup")) {
            if (this.has(name)) {
                try {
                    result = OptionUtils.forAnyCommandLine(Object.class, this.m_Properties.getProperty(name));
                }
                catch (Exception e) {
                    System.err.println("Failed to get named setup '" + name + "':");
                    e.printStackTrace();
                    if (defValue != null) {
                        System.err.println("Using default for named setup '" + name + "': " + OptionUtils.getCommandLine(defValue));
                    }
                    result = defValue;
                }
            } else {
                System.err.println("Named setup '" + name + "' does not exist" + (defValue != null ? ", using default instead: " + OptionUtils.getCommandLine(defValue) : "!"));
            }
        }
        return result;
    }

    public Object add(String name, Object setup) {
        Object result = this.has(name) ? this.get(name) : null;
        this.m_Properties.setProperty(name, OptionUtils.getCommandLine(setup));
        return result;
    }

    public Object remove(String name) {
        Object result = this.has(name) ? this.get(name) : null;
        this.m_Properties.removeKeyRecursive(name);
        return result;
    }

    public boolean save() {
        return Environment.getInstance().write("named setups", this.m_Properties);
    }

    public static synchronized NamedSetups getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new NamedSetups();
        }
        return m_Singleton;
    }
}

