/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.CustomDisplayStringProvider;
import adams.core.ExampleProvider;
import adams.core.HelpProvider;
import gnu.trove.list.array.TIntArrayList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class Range
implements Serializable,
CustomDisplayStringProvider,
Comparable<Range>,
ExampleProvider,
HelpProvider {
    private static final long serialVersionUID = -7995710565507092711L;
    public static final String RANGE = "-";
    public static final String SEPARATOR = ",";
    public static final String FIRST = "first";
    public static final String SECOND = "second";
    public static final String THIRD = "third";
    public static final String LAST_1 = "last_1";
    public static final String LAST_2 = "last_2";
    public static final String LAST = "last";
    public static final String INV_START = "inv(";
    public static final String INV_END = ")";
    public static final String ALL = "first-last";
    protected String m_Raw;
    protected String m_Range;
    protected String m_ActualRange;
    protected int m_Max;
    protected Boolean m_Inverted;
    protected List<SubRange> m_SubRanges;

    public Range() {
        this("");
    }

    public Range(String range) {
        this(range, -1);
    }

    public Range(String range, int max) {
        this.initialize();
        this.setRange(range);
        this.setMax(max);
    }

    protected void initialize() {
        this.m_Range = null;
        this.m_Raw = null;
        this.m_Max = -1;
        this.reset();
    }

    protected void reset() {
        this.m_SubRanges = null;
        this.m_Inverted = null;
        this.m_ActualRange = null;
    }

    public void setRange(String value) {
        this.reset();
        this.m_Raw = value;
        this.m_Range = null;
    }

    public void setIndices(Integer[] indices) {
        int[] intIndices = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            intIndices[i] = indices[i];
        }
        this.setIndices(intIndices);
    }

    public void setIndices(int[] indices) {
        StringBuilder range = new StringBuilder();
        int start = -1;
        int end = -1;
        if (indices.length > 0) {
            start = indices[0];
        }
        for (int i = 1; i < indices.length; ++i) {
            int diff = indices[i] - indices[i - 1];
            if (diff > 1) {
                if (range.length() > 0) {
                    range.append(SEPARATOR);
                }
                if (start != indices[i - 1]) {
                    range.append(start + 1 + RANGE + (indices[i - 1] + 1));
                } else {
                    range.append(start + 1);
                }
                start = indices[i];
                end = -1;
                continue;
            }
            end = indices[i];
        }
        if (start != -1) {
            if (end != -1) {
                if (range.length() > 0) {
                    range.append(SEPARATOR);
                }
                if (start != end) {
                    range.append(start + 1 + RANGE + (end + 1));
                } else {
                    range.append(start + 1);
                }
            } else {
                if (range.length() > 0) {
                    range.append(SEPARATOR);
                }
                range.append(start + 1);
            }
        }
        this.setRange(range.toString());
    }

    public synchronized boolean isInverted() {
        if (this.m_Inverted == null) {
            this.m_Inverted = this.getRange().startsWith(INV_START) && this.getRange().endsWith(INV_END);
        }
        return this.m_Inverted;
    }

    public void setInverted(boolean value) {
        if (value) {
            this.setRange(INV_START + this.getActualRange() + INV_END);
        } else {
            this.setRange(this.getActualRange());
        }
    }

    public synchronized String getRange() {
        if (this.m_Range == null) {
            this.m_Range = this.clean(this.m_Raw);
        }
        if (this.m_Range.isEmpty()) {
            return this.m_Raw;
        }
        return this.m_Range;
    }

    protected synchronized String getActualRange() {
        if (this.m_ActualRange == null) {
            this.m_ActualRange = this.isInverted() ? this.getRange().substring(INV_START.length(), this.getRange().length() - INV_END.length()) : this.getRange();
        }
        return this.m_ActualRange;
    }

    public void setMax(int value) {
        if (value != this.m_Max) {
            this.m_Max = value <= 0 ? -1 : value;
            this.reset();
        }
    }

    public int getMax() {
        return this.m_Max;
    }

    public boolean hasRange() {
        return this.getRange().length() > 0;
    }

    protected String removeInvalidChars(String s, List<String> valid) {
        int i;
        char chr;
        for (chr = '0'; chr <= '9'; chr = (char)(chr + '\u0001')) {
            valid.add(Character.toString(chr));
        }
        valid.add(RANGE);
        valid.add(SEPARATOR);
        ArrayList<Character> chars = new ArrayList<Character>();
        HashMap<Character, String> relation = new HashMap<Character, String>();
        for (i = 0; i < valid.size(); ++i) {
            chr = (char)i;
            chars.add(Character.valueOf(chr));
            relation.put(Character.valueOf(chr), valid.get(i));
        }
        String shortened = s.toLowerCase();
        for (i = 0; i < chars.size(); ++i) {
            shortened = shortened.replace(((String)relation.get(chars.get(i))).toLowerCase(), ((Character)chars.get(i)).toString());
        }
        StringBuilder result = new StringBuilder();
        for (i = 0; i < shortened.length(); ++i) {
            chr = shortened.charAt(i);
            if (!relation.containsKey(Character.valueOf(chr))) continue;
            result.append((String)relation.get(Character.valueOf(chr)));
        }
        return result.toString();
    }

    protected List<String> getPlaceholders() {
        return new ArrayList<String>(Arrays.asList(FIRST, SECOND, THIRD, LAST_2, LAST_1, LAST, INV_START, INV_END));
    }

    protected String removeInvalidChars(String s) {
        return this.removeInvalidChars(s, this.getPlaceholders());
    }

    protected boolean canReplaceInvalidChars() {
        return true;
    }

    protected String[] splitList(String s) {
        return s.split(SEPARATOR);
    }

    protected String[] splitRange(String s) {
        return s.split(RANGE);
    }

    protected String clean(String s) {
        StringBuilder result = new StringBuilder();
        String tmp = this.canReplaceInvalidChars() ? this.removeInvalidChars(s) : s;
        boolean inverted = false;
        if (tmp.length() >= INV_START.length() + 1 + INV_END.length()) {
            boolean bl = inverted = tmp.startsWith(INV_START) && tmp.endsWith(INV_END);
            if (inverted) {
                tmp = tmp.substring(INV_START.length(), tmp.length() - INV_END.length());
            }
        }
        String[] ranges = this.splitList(tmp);
        for (int i = 0; i < ranges.length; ++i) {
            String[] parts = this.splitRange(ranges[i]);
            if (parts.length == 1) {
                try {
                    if (this.canReplaceInvalidChars()) {
                        this.parse(parts[0]);
                    }
                    if (result.length() > 0) {
                        result.append(SEPARATOR);
                    }
                    result.append(parts[0]);
                }
                catch (Exception e) {}
                continue;
            }
            if (parts.length != 2) continue;
            try {
                int to;
                int from;
                if (this.canReplaceInvalidChars()) {
                    from = this.parse(parts[0], Integer.MAX_VALUE);
                    to = this.parse(parts[1], Integer.MAX_VALUE);
                } else {
                    from = 0;
                    to = 0;
                }
                if (from > to) continue;
                if (result.length() > 0) {
                    result.append(SEPARATOR);
                }
                result.append(ranges[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (inverted) {
            result.insert(0, INV_START);
            result.append(INV_END);
        }
        return result.toString();
    }

    protected boolean isPlaceholder(String s) {
        String tmp = s.toLowerCase();
        if (tmp.equals(FIRST)) {
            return true;
        }
        if (tmp.equals(SECOND)) {
            return true;
        }
        if (tmp.equals(THIRD)) {
            return true;
        }
        if (tmp.equals(LAST_2)) {
            return true;
        }
        if (tmp.equals(LAST_1)) {
            return true;
        }
        return tmp.equals(LAST);
    }

    protected int parsePlaceholder(String s, int max) {
        if (s.equals(FIRST)) {
            return 0;
        }
        if (s.equals(SECOND)) {
            return 1;
        }
        if (s.equals(THIRD)) {
            return 2;
        }
        if (s.equals(LAST_2)) {
            return max - 3;
        }
        if (s.equals(LAST_1)) {
            return max - 2;
        }
        if (s.equals(LAST)) {
            return max - 1;
        }
        return -1;
    }

    protected int parse(String s, int max) {
        int result;
        if (this.isPlaceholder(s)) {
            result = this.parsePlaceholder(s, max);
        } else {
            try {
                result = Integer.parseInt(s) - 1;
            }
            catch (Exception e) {
                result = -1;
            }
        }
        return result;
    }

    protected int parse(String s) {
        return this.parse(s, this.m_Max);
    }

    protected List<SubRange> parse(StringBuilder errors) {
        if (errors.length() > 0) {
            errors.delete(0, errors.length());
        }
        ArrayList<SubRange> result = new ArrayList<SubRange>();
        if (this.m_Max == -1) {
            return result;
        }
        String[] ranges = this.splitList(this.getActualRange());
        for (int i = 0; i < ranges.length; ++i) {
            int to;
            int from;
            if (ranges[i].length() == 0) continue;
            String[] parts = this.splitRange(ranges[i]);
            if (parts.length == 1) {
                from = this.parse(parts[0]);
                if (from >= 0 && from < this.m_Max) {
                    result.add(new SubRange(from));
                    continue;
                }
                errors.append(parts[0] + "\n");
                continue;
            }
            from = this.parse(parts[0]);
            if (from <= (to = this.parse(parts[1])) && from >= 0 && to < this.m_Max) {
                result.add(new SubRange(from, to));
                continue;
            }
            if (from <= to && from >= 0 && from < this.m_Max) {
                result.add(new SubRange(from, this.m_Max));
                continue;
            }
            errors.append(ranges[i] + "\n");
        }
        return result;
    }

    protected synchronized List<SubRange> getSubRanges() {
        if (this.m_SubRanges == null) {
            this.m_SubRanges = this.parse(new StringBuilder());
        }
        return this.m_SubRanges;
    }

    public boolean isInRange(int index) {
        boolean result = this.isInverted();
        List<SubRange> ranges = this.getSubRanges();
        for (int i = 0; i < ranges.size(); ++i) {
            if (this.isInverted()) {
                if (!ranges.get(i).isInRange(index)) continue;
                result = false;
                break;
            }
            if (!ranges.get(i).isInRange(index)) continue;
            result = true;
            break;
        }
        return result;
    }

    public int[] getIntIndices() {
        TIntArrayList result = new TIntArrayList();
        for (int i = 0; i < this.m_Max; ++i) {
            if (!this.isInRange(i)) continue;
            result.add(i);
        }
        return result.toArray();
    }

    public int[][] getIntSegments() {
        if (this.getSubRanges() == null) {
            return new int[0][];
        }
        int[][] result = new int[this.getSubRanges().size()][2];
        for (int i = 0; i < this.getSubRanges().size(); ++i) {
            SubRange sub = this.getSubRanges().get(i);
            result[i][0] = sub.getFrom();
            result[i][1] = sub.hasTo() ? sub.getTo().intValue() : sub.getFrom().intValue();
        }
        return result;
    }

    public boolean isAllRange() {
        return this.getRange().equals(ALL);
    }

    public boolean isEmpty() {
        return this.getRange().isEmpty();
    }

    @Override
    public int compareTo(Range o) {
        int[] indicesOther;
        int[] indicesThis = this.getIntIndices();
        int result = new Integer(indicesThis.length).compareTo(new Integer((indicesOther = o.getIntIndices()).length));
        if (result == 0) {
            for (int i = 0; i < indicesThis.length && (result = new Integer(indicesThis[i]).compareTo(new Integer(indicesOther[i]))) == 0; ++i) {
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Range)) {
            return false;
        }
        return this.compareTo((Range)obj) == 0;
    }

    public int hashCode() {
        return this.getRange().hashCode();
    }

    public String toString() {
        return "range=" + this.getRange() + ", max=" + this.m_Max + ", inv=" + this.isInverted();
    }

    @Override
    public String toDisplay() {
        return this.getRange();
    }

    public String toExplicitRange() {
        StringBuilder result = new StringBuilder();
        int[] indices = this.getIntIndices();
        for (int i = 0; i < indices.length; ++i) {
            if (i > 0) {
                result.append(SEPARATOR);
            }
            result.append("" + (indices[i] + 1));
        }
        return result.toString();
    }

    @Override
    public String getExample() {
        return "A range is a comma-separated list of single 1-based indices or sub-ranges of indices ('start-end'); 'inv(...)' inverts the range '...'; the following placeholders can be used as well: first, second, third, last_2, last_1, last";
    }

    @Override
    public String getHelpURL() {
        return null;
    }

    @Override
    public String getHelpDescription() {
        return this.getExample();
    }

    @Override
    public String getHelpTitle() {
        return null;
    }

    @Override
    public String getHelpIcon() {
        return "help2.png";
    }

    public static Range toRange(int[] indices) {
        if (indices.length == 0) {
            return new Range();
        }
        StringBuilder range = new StringBuilder();
        int i = 1;
        Integer start = indices[0];
        Integer current = indices[0];
        range.append(current + 1);
        while (i < indices.length) {
            if (indices[i] - current > 1) {
                if (start < current) {
                    range.append(RANGE);
                    range.append(current + 1);
                }
                range.append(SEPARATOR);
                start = indices[i];
                current = indices[i];
                range.append(current + 1);
            } else {
                current = indices[i];
            }
            if (++i != indices.length || start >= current) continue;
            range.append(RANGE);
            range.append(current + 1);
        }
        Range result = new Range(range.toString());
        return result;
    }

    public static boolean isValid(String s, int max) {
        Range range = new Range(s);
        boolean result = s.equals(range.getRange()) && range.getRange().length() > 0;
        return result;
    }

    public static class SubRange
    implements Serializable,
    Comparable<SubRange> {
        private static final long serialVersionUID = -1352323320597824993L;
        protected Integer m_From;
        protected Integer m_To;

        public SubRange(int from) {
            this(from, null);
        }

        public SubRange(int from, Integer to) {
            this.m_From = from;
            this.m_To = to;
        }

        public Integer getFrom() {
            return this.m_From;
        }

        public boolean hasTo() {
            return this.m_To != null;
        }

        public Integer getTo() {
            return this.m_To;
        }

        public boolean isInRange(int index) {
            if (this.m_To == null) {
                return this.m_From == index;
            }
            return this.m_From <= index && index <= this.m_To;
        }

        @Override
        public int compareTo(SubRange o) {
            int result = this.getFrom().compareTo(o.getFrom());
            if (result == 0) {
                result = this.hasTo() && o.hasTo() ? this.getTo().compareTo(o.getTo()) : (!this.hasTo() ? -1 : 1);
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SubRange)) {
                return false;
            }
            return this.compareTo((SubRange)obj) == 0;
        }

        public String toString() {
            if (this.m_To == null) {
                return "num=" + this.m_From;
            }
            return "from=" + this.m_From + ", to=" + this.m_To;
        }
    }
}

