/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.License;
import adams.core.SerializedObject;
import adams.core.annotation.MixedCopyright;
import adams.core.logging.LoggingObject;
import adams.core.management.LocaleHelper;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;

public class Utils {
    public static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String ARRAY_INDICATOR = "[]";

    public static String doubleToStringFixed(double value, int afterDecimalPoint) {
        return Utils.doubleToStringFixed(value, afterDecimalPoint, LocaleHelper.getSingleton().getDefault());
    }

    public static String doubleToStringFixed(double value, int afterDecimalPoint, Locale locale) {
        StringBuilder result;
        if (afterDecimalPoint < 0 || value > 9.223372036854776E18 || value < -9.223372036854776E18) {
            result = new StringBuilder(LocaleHelper.getSingleton().getNumberFormat(locale).format(value));
        } else {
            boolean negative;
            boolean bl = negative = value < 0.0;
            if (negative) {
                value *= -1.0;
            }
            char separator = LocaleHelper.getSingleton().getDecimalSeparator(locale);
            double factor = Math.pow(10.0, afterDecimalPoint);
            double valueNew = Math.floor(value * factor) / factor;
            result = new StringBuilder(Long.toString(Math.round(Math.floor(valueNew))));
            StringBuilder remainder = new StringBuilder("" + Math.round((valueNew - Math.floor(valueNew)) * Math.pow(10.0, afterDecimalPoint)));
            remainder.delete(0, remainder.indexOf("" + separator) + 1);
            if (afterDecimalPoint > 0) {
                while (remainder.length() < afterDecimalPoint) {
                    remainder.insert(0, '0');
                }
                result.append(separator);
                result.append(remainder.substring(0, afterDecimalPoint));
            }
            if (negative && valueNew != 0.0) {
                result.insert(0, "-");
            }
        }
        return result.toString();
    }

    public static String doubleToString(double value, int afterDecimalPoint) {
        return Utils.doubleToString(value, afterDecimalPoint, LocaleHelper.getSingleton().getDefault());
    }

    public static String doubleToString(double value, int afterDecimalPoint, Locale locale) {
        double temp = value * Math.pow(10.0, afterDecimalPoint);
        if (Math.abs(temp) < 9.223372036854776E18) {
            int dotPosition;
            long precisionValue = temp > 0.0 ? (long)(temp + 0.5) : -((long)(Math.abs(temp) + 0.5));
            StringBuilder builder = precisionValue == 0L ? new StringBuilder(String.valueOf(0)) : new StringBuilder(String.valueOf(precisionValue));
            if (afterDecimalPoint == 0) {
                return builder.toString();
            }
            char separator = LocaleHelper.getSingleton().getDecimalSeparator(locale);
            for (dotPosition = builder.length() - afterDecimalPoint; precisionValue < 0L && dotPosition < 1 || dotPosition < 0; ++dotPosition) {
                if (precisionValue < 0L) {
                    builder.insert(1, '0');
                    continue;
                }
                builder.insert(0, '0');
            }
            builder.insert(dotPosition, separator);
            if (precisionValue < 0L && builder.charAt(1) == separator) {
                builder.insert(1, '0');
            } else if (builder.charAt(0) == separator) {
                builder.insert(0, '0');
            }
            int currentPos = builder.length() - 1;
            while (currentPos > dotPosition && builder.charAt(currentPos) == '0') {
                builder.setCharAt(currentPos--, ' ');
            }
            if (builder.charAt(currentPos) == separator) {
                builder.setCharAt(currentPos, ' ');
            }
            return builder.toString().trim();
        }
        return new String("" + value);
    }

    public static String doubleToString(double value, int width, int afterDecimalPoint) {
        return Utils.doubleToString(value, width, afterDecimalPoint, LocaleHelper.getSingleton().getDefault());
    }

    public static String doubleToString(double value, int width, int afterDecimalPoint, Locale locale) {
        int dotPosition;
        int i;
        String tempString = Utils.doubleToString(value, afterDecimalPoint, locale);
        if (afterDecimalPoint >= width || tempString.indexOf(69) != -1) {
            return tempString;
        }
        char[] result = new char[width];
        for (i = 0; i < result.length; ++i) {
            result[i] = 32;
        }
        if (afterDecimalPoint > 0) {
            char separator = LocaleHelper.getSingleton().getDecimalSeparator(locale);
            dotPosition = tempString.indexOf(separator);
            if (dotPosition == -1) {
                dotPosition = tempString.length();
            } else {
                result[width - afterDecimalPoint - 1] = separator;
            }
        } else {
            dotPosition = tempString.length();
        }
        int offset = width - afterDecimalPoint - dotPosition;
        if (afterDecimalPoint > 0) {
            --offset;
        }
        if (offset < 0) {
            return tempString;
        }
        for (i = 0; i < dotPosition; ++i) {
            result[offset + i] = tempString.charAt(i);
        }
        for (i = dotPosition + 1; i < tempString.length(); ++i) {
            result[offset + i] = tempString.charAt(i);
        }
        return new String(result);
    }

    public static Class getArrayClass(Class c) {
        if (c.getComponentType().isArray()) {
            return Utils.getArrayClass(c.getComponentType());
        }
        return c.getComponentType();
    }

    public static int getArrayDimensions(Class array) {
        if (array.getComponentType().isArray()) {
            return 1 + Utils.getArrayDimensions(array.getComponentType());
        }
        return 1;
    }

    public static int getArrayDimensions(Object array) {
        return Utils.getArrayDimensions(array.getClass());
    }

    public static String arrayToString(Object array, boolean outputClass) {
        StringBuilder result = new StringBuilder();
        int dimensions = Utils.getArrayDimensions(array);
        if (dimensions == 0) {
            result.append("null");
        } else if (dimensions == 1) {
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (i > 0) {
                    result.append(",");
                }
                if (Array.get(array, i) == null) {
                    result.append("null");
                    continue;
                }
                Object obj = Array.get(array, i);
                if (outputClass) {
                    if (obj instanceof Class) {
                        result.append(((Class)obj).getName());
                        continue;
                    }
                    result.append(obj.getClass().getName());
                    continue;
                }
                result.append(obj.toString());
            }
        } else {
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (i > 0) {
                    result.append(",");
                }
                result.append("[" + Utils.arrayToString(Array.get(array, i)) + "]");
            }
        }
        return result.toString();
    }

    public static String arrayToString(Object array) {
        return Utils.arrayToString(array, false);
    }

    public static String backQuoteChars(String string, char[] find, String[] replace) {
        if (string == null) {
            return string;
        }
        for (int i = 0; i < find.length; ++i) {
            int index;
            if (string.indexOf(find[i]) == -1) continue;
            StringBuilder newStr = new StringBuilder();
            while ((index = string.indexOf(find[i])) != -1) {
                if (index > 0) {
                    newStr.append(string.substring(0, index));
                }
                newStr.append(replace[i]);
                if (index + 1 < string.length()) {
                    string = string.substring(index + 1);
                    continue;
                }
                string = "";
            }
            newStr.append(string);
            string = newStr.toString();
        }
        return string;
    }

    public static String backQuoteChars(String string) {
        return Utils.backQuoteChars(string, new char[]{'\\', '\'', '\t', '\n', '\r', '\"'}, new String[]{"\\\\", "\\'", "\\t", "\\n", "\\r", "\\\""});
    }

    public static String unbackQuoteChars(String string, String[] find, char[] replace) {
        if (string == null) {
            return null;
        }
        int[] pos = new int[find.length];
        String str = new String(string);
        StringBuilder newStr = new StringBuilder();
        while (str.length() > 0) {
            int curPos = str.length();
            int index = -1;
            for (int i = 0; i < pos.length; ++i) {
                pos[i] = str.indexOf(find[i]);
                if (pos[i] <= -1 || pos[i] >= curPos) continue;
                index = i;
                curPos = pos[i];
            }
            if (index == -1) {
                newStr.append(str);
                str = "";
                continue;
            }
            newStr.append(str.substring(0, pos[index]));
            newStr.append(replace[index]);
            str = str.substring(pos[index] + find[index].length());
        }
        return newStr.toString();
    }

    public static String unbackQuoteChars(String string) {
        return Utils.unbackQuoteChars(string, new String[]{"\\\\", "\\'", "\\t", "\\n", "\\r", "\\\""}, new char[]{'\\', '\'', '\t', '\n', '\r', '\"'});
    }

    public static String doubleQuote(String string) {
        return Utils.quote(string, "\"");
    }

    public static String quote(String string) {
        return Utils.quote(string, "'");
    }

    public static String quote(String string, String quoteChar) {
        if (string == null) {
            return string;
        }
        boolean quote = false;
        if (string.indexOf(10) != -1 || string.indexOf(13) != -1 || string.indexOf(39) != -1 || string.indexOf(34) != -1 || string.indexOf(92) != -1 || string.indexOf(9) != -1) {
            string = Utils.backQuoteChars(string);
            quote = true;
        }
        if (quote || string.indexOf(123) != -1 || string.indexOf(125) != -1 || string.indexOf(44) != -1 || string.equals("?") || string.indexOf(32) != -1 || string.equals("")) {
            string = new String(quoteChar).concat(string).concat(new String(quoteChar));
        }
        return string;
    }

    public static String unDoubleQuote(String string) {
        return Utils.unquote(string, "\"");
    }

    public static String unquote(String string) {
        return Utils.unquote(string, "'");
    }

    public static String unquote(String string, String quoteChar) {
        if (string == null || string.length() < 2) {
            return string;
        }
        if (string.startsWith(quoteChar) && string.endsWith(quoteChar) && ((string = string.substring(1, string.length() - 1)).indexOf("\\n") != -1 || string.indexOf("\\r") != -1 || string.indexOf("\\'") != -1 || string.indexOf("\\\"") != -1 || string.indexOf("\\\\") != -1 || string.indexOf("\\t") != -1)) {
            string = Utils.unbackQuoteChars(string);
        }
        return string;
    }

    public static String doubleUpQuotes(String s, char quote, char[] chars, String[] strings) {
        if (chars.length != strings.length) {
            throw new IllegalArgumentException("No the same number of chars and strings provided: " + chars.length + " != " + strings.length);
        }
        char[] newChars = new char[chars.length + 1];
        newChars[0] = quote;
        System.arraycopy(chars, 0, newChars, 1, chars.length);
        String[] newStrings = new String[strings.length + 1];
        newStrings[0] = "" + quote + quote;
        System.arraycopy(strings, 0, newStrings, 1, strings.length);
        return quote + Utils.backQuoteChars(s, newChars, newStrings) + quote;
    }

    public static String unDoubleUpQuotes(String s, char quote, String[] strings, char[] chars) {
        if (chars.length != strings.length) {
            throw new IllegalArgumentException("No the same number of strings and chars provided: " + strings.length + " != " + chars.length);
        }
        if (s.startsWith("" + quote) && s.endsWith("" + quote)) {
            char[] newChars = new char[chars.length + 1];
            newChars[0] = quote;
            System.arraycopy(chars, 0, newChars, 1, chars.length);
            String[] newStrings = new String[strings.length + 1];
            newStrings[0] = "" + quote + quote;
            System.arraycopy(strings, 0, newStrings, 1, strings.length);
            return Utils.unbackQuoteChars(s.substring(1, s.length() - 1), newStrings, newChars);
        }
        return s;
    }

    public static Object deepCopy(Object o) {
        Object result;
        try {
            SerializedObject so = new SerializedObject((Serializable)o);
            result = so.getObject();
        }
        catch (Exception e) {
            System.err.println("Failed to serialize " + o.getClass().getName() + ":");
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static Object newInstance(Object o) {
        Object result;
        try {
            result = o.getClass().newInstance();
        }
        catch (Exception e) {
            System.err.println("Error creating new instance for " + o.getClass().getName() + ":");
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static String[] breakUp(String s, int columns) {
        ArrayList<String> result = new ArrayList<String>();
        String punctuation = " .,;:!?'\"";
        String[] lines = s.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            BreakIterator boundary = BreakIterator.getWordInstance();
            boundary.setText(lines[i]);
            int boundaryStart = boundary.first();
            int boundaryEnd = boundary.next();
            String line = "";
            while (boundaryEnd != -1) {
                String word = lines[i].substring(boundaryStart, boundaryEnd);
                if (line.length() >= columns) {
                    if (word.length() == 1 && punctuation.indexOf(word.charAt(0)) > -1) {
                        line = line + word;
                        word = "";
                    }
                    result.add(line);
                    line = "";
                }
                line = line + word;
                boundaryStart = boundaryEnd;
                boundaryEnd = boundary.next();
            }
            if (line.length() <= 0) continue;
            result.add(line);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String insertLineBreaks(String s, int columns) {
        StringBuilder result = new StringBuilder();
        String[] lines = Utils.breakUp(s, columns);
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                result.append("\n");
            }
            result.append(lines[i]);
        }
        return result.toString();
    }

    public static String shorten(String s, int max) {
        if (s.length() > max) {
            return s.substring(0, max) + "...";
        }
        return s;
    }

    public static String commentOut(String s, String comment) {
        return Utils.indent(s, comment);
    }

    public static String indent(String s, int numBlanks) {
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < numBlanks; ++i) {
            indent.append(" ");
        }
        return Utils.indent(s, indent.toString());
    }

    protected static String indent(String s, String indentStr) {
        StringBuilder result = new StringBuilder();
        String[] lines = s.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            result.append(indentStr);
            result.append(lines[i]);
            result.append("\n");
        }
        return result.toString();
    }

    public static String unComment(String s, String comment) {
        StringBuilder result = new StringBuilder();
        String[] lines = s.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].startsWith(comment)) {
                result.append(lines[i].substring(comment.length()));
            } else {
                result.append(lines[i]);
            }
            result.append("\n");
        }
        return result.toString();
    }

    public static String flatten(List lines, String sep) {
        return Utils.flatten(lines.toArray(new Object[lines.size()]), sep);
    }

    public static String flatten(Object[] lines, String sep) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                result.append(sep);
            }
            result.append(lines[i].toString());
        }
        return result.toString();
    }

    public static void removeEmptyLines(List<String> lines) {
        Utils.removeEmptyLines(lines, true);
    }

    public static void removeEmptyLines(List<String> lines, boolean trim) {
        int i = 0;
        while (i < lines.size()) {
            String line = trim ? lines.get(i).trim() : lines.get(i);
            if (line.length() == 0) {
                lines.remove(i);
                continue;
            }
            ++i;
        }
    }

    public static void removeComments(List<String> lines, String comment) {
        int i = 0;
        while (i < lines.size()) {
            if (lines.get(i).startsWith(comment)) {
                lines.remove(i);
                continue;
            }
            ++i;
        }
    }

    public static int compare(Comparable o1, Comparable o2) {
        if (o1 != null && o2 != null) {
            return o1.compareTo(o2);
        }
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        return 1;
    }

    public static Object adjustArray(Object array, int newLen, Object defValue) {
        boolean serializable = defValue instanceof Serializable;
        Object result = Array.newInstance(defValue.getClass(), newLen);
        for (int i = 0; i < Array.getLength(result); ++i) {
            if (serializable) {
                Array.set(result, i, Utils.deepCopy(defValue));
                continue;
            }
            Array.set(result, i, defValue);
        }
        if (array != null) {
            System.arraycopy(array, 0, result, 0, Array.getLength(array) < Array.getLength(result) ? Array.getLength(array) : Array.getLength(result));
        }
        return result;
    }

    public static Class stringToClass(String classname) {
        Class<?> result = null;
        int arrayDim = 0;
        if (classname.endsWith(ARRAY_INDICATOR)) {
            String arrays = classname.substring(classname.indexOf(ARRAY_INDICATOR));
            arrays = arrays.replace("][", "],[");
            arrayDim = arrays.split(",").length;
            classname = classname.substring(0, classname.indexOf(ARRAY_INDICATOR));
        }
        try {
            result = Class.forName(classname);
            for (int i = 0; i < arrayDim; ++i) {
                result = Array.newInstance(result, 0).getClass();
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static Object newArray(String elementClass, int length) {
        Object result;
        try {
            result = Array.newInstance(Utils.stringToClass(elementClass), length);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static String classToString(Class c) {
        String result;
        if (c.isArray()) {
            int dim = Utils.getArrayDimensions(c);
            result = Utils.getArrayClass(c).getName();
            for (int i = 0; i < dim; ++i) {
                result = result + ARRAY_INDICATOR;
            }
        } else {
            result = c.getName();
        }
        return result;
    }

    public static String classesToString(Class[] c) {
        return Utils.classesToString(c, ", ");
    }

    public static String classesToString(Class[] c, String separator) {
        StringBuilder result = new StringBuilder();
        for (Class cls : c) {
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(Utils.classToString(cls));
        }
        return result.toString();
    }

    public static float[] toFloat(double[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (float)array[i];
        }
        return result;
    }

    public static double[] toDouble(float[] array) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static String padLeft(String s, char padding, int width) {
        return Utils.padLeft(s, padding, width, false);
    }

    public static String padLeft(String s, char padding, int width, boolean truncate) {
        StringBuilder result = new StringBuilder(s);
        while (result.length() < width) {
            result.insert(0, padding);
        }
        if (truncate && result.length() > width) {
            result.delete(0, result.length() - width);
        }
        return result.toString();
    }

    public static String throwableToString(Throwable t) {
        return Utils.throwableToString(t, -1);
    }

    public static String throwableToString(Throwable t, int maxLines) {
        StringBuilder result;
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        if (maxLines > 0) {
            result = new StringBuilder();
            String[] lines = writer.toString().split("\n");
            for (int i = 0; i < maxLines; ++i) {
                if (i > 0) {
                    result.append("\n");
                }
                result.append(lines[i]);
            }
        } else {
            result = new StringBuilder(writer.toString());
        }
        return result.toString();
    }

    public static String getStackTrace(int maxDepth) {
        StringBuilder result = new StringBuilder();
        Throwable th = new Throwable();
        th.fillInStackTrace();
        StackTraceElement[] trace = th.getStackTrace();
        if (maxDepth <= 0) {
            maxDepth = trace.length - 1;
        }
        ++maxDepth;
        maxDepth = Math.min(maxDepth, trace.length);
        for (int i = 1; i < maxDepth; ++i) {
            if (i > 1) {
                result.append("\n");
            }
            result.append(trace[i]);
        }
        return result.toString();
    }

    public static List<Integer> toBase(int n, int base) {
        int times;
        ArrayList<Integer> result = new ArrayList<Integer>();
        int current = n;
        do {
            times = current / base;
            int remainder = current - times * base;
            result.add(remainder);
            current = times;
        } while (times > 0);
        return result;
    }

    @MixedCopyright(copyright="2006 Dr. Herong Yang", author="Dr. Herong Yang", license=License.PUBLIC_DOMAIN, url="http://www.herongyang.com/Cryptography/SHA1-Message-Digest-in-Java.html")
    public static String toHex(byte value) {
        StringBuilder result = new StringBuilder();
        result.append(HEX_DIGIT[value >> 4 & 0xF]);
        result.append(HEX_DIGIT[value & 0xF]);
        return result.toString();
    }

    public static String toHex(byte[] binary) {
        return Utils.toHex(binary, 16);
    }

    public static String toHex(byte[] binary, int columns) {
        int width = ("" + binary.length).length();
        StringBuilder hex = new StringBuilder(binary.length * 5);
        StringBuilder human = new StringBuilder();
        for (int i = 0; i < binary.length; ++i) {
            if (i % columns == 0) {
                if (i > 0) {
                    hex.append(" | ");
                    hex.append(human.toString());
                    hex.append("\n");
                    human.delete(0, human.length());
                }
                hex.append(Utils.padLeft("" + (i + 1), '0', width));
                hex.append("-");
                hex.append(Utils.padLeft("" + (i + columns), '0', width));
                hex.append(" |");
            }
            hex.append(" ");
            hex.append(Utils.toHex(binary[i]));
            if (binary[i] > 31) {
                human.append((char)binary[i]);
                continue;
            }
            human.append(".");
        }
        return hex.toString();
    }

    public static boolean isBoolean(String s) {
        return (s = s.toLowerCase()).equals("true") || s.equals("false");
    }

    public static boolean isByte(String s) {
        try {
            Byte.parseByte(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isShort(String s) {
        try {
            Short.parseShort(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isLong(String s) {
        try {
            Long.parseLong(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFloat(String s) {
        return Utils.isFloat(s, LocaleHelper.getSingleton().getDefault());
    }

    public static boolean isFloat(String s, Locale locale) {
        return Utils.toFloat(s, locale) != null;
    }

    public static Float toFloat(String s) {
        return Utils.toFloat(s, LocaleHelper.getSingleton().getDefault());
    }

    public static Float toFloat(String s, Locale locale) {
        char grouping = LocaleHelper.getSingleton().getGroupingSeparator(locale);
        char decimal = LocaleHelper.getSingleton().getDecimalSeparator(locale);
        s = s.replace("" + grouping, "");
        s = s.replace(decimal, '.');
        try {
            return Float.valueOf(Float.parseFloat(s));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isDouble(String s) {
        return Utils.isDouble(s, LocaleHelper.getSingleton().getDefault());
    }

    public static boolean isDouble(String s, Locale locale) {
        return Utils.toDouble(s, locale) != null;
    }

    public static Double toDouble(String s) {
        return Utils.toDouble(s, LocaleHelper.getSingleton().getDefault());
    }

    public static Double toDouble(String s, Locale locale) {
        char grouping = LocaleHelper.getSingleton().getGroupingSeparator(locale);
        char decimal = LocaleHelper.getSingleton().getDecimalSeparator(locale);
        s = s.replace("" + grouping, "");
        s = s.replace(decimal, '.');
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String[] split(String line, char delimiter) {
        return Utils.split(line, "" + delimiter);
    }

    public static String[] split(String line, String delimiter) {
        int currPos;
        ArrayList<String> result = new ArrayList<String>();
        int lastPos = -1;
        while ((currPos = line.indexOf(delimiter, lastPos + 1)) > -1) {
            result.add(line.substring(lastPos + 1, currPos));
            lastPos = currPos;
        }
        result.add(line.substring(lastPos + 1));
        return result.toArray(new String[result.size()]);
    }

    public static void swap(int[] array) {
        if (array.length == 2) {
            int tmp = array[0];
            array[0] = array[1];
            array[1] = tmp;
        }
    }

    public static void swap(long[] array) {
        if (array.length == 2) {
            long tmp = array[0];
            array[0] = array[1];
            array[1] = tmp;
        }
    }

    public static void swap(float[] array) {
        if (array.length == 2) {
            float tmp = array[0];
            array[0] = array[1];
            array[1] = tmp;
        }
    }

    public static void swap(double[] array) {
        if (array.length == 2) {
            double tmp = array[0];
            array[0] = array[1];
            array[1] = tmp;
        }
    }

    public static void swap(Object[] array) {
        if (array.length == 2) {
            Object tmp = array[0];
            array[0] = array[1];
            array[1] = tmp;
        }
    }

    public static List<Byte> toList(byte[] array) {
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (byte element : array) {
            result.add(element);
        }
        return result;
    }

    public static byte[] toByteArray(List<Byte> list) {
        byte[] result = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static List<Integer> toList(int[] array) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int element : array) {
            result.add(element);
        }
        return result;
    }

    public static int[] toIntArray(List<Integer> list) {
        int[] result = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static List<Long> toList(long[] array) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (long element : array) {
            result.add(element);
        }
        return result;
    }

    public static long[] toLongArray(List<Long> list) {
        long[] result = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static List<Double> toList(double[] array) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (double element : array) {
            result.add(element);
        }
        return result;
    }

    public static double[] toDoubleArray(List<Double> list) {
        double[] result = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static List<Float> toList(float[] array) {
        ArrayList<Float> result = new ArrayList<Float>();
        for (float element : array) {
            result.add(Float.valueOf(element));
        }
        return result;
    }

    public static float[] toFloatArray(List<Float> list) {
        float[] result = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i).floatValue();
        }
        return result;
    }

    public static String handleException(LoggingObject source, String msg, Throwable t) {
        String result = msg.trim() + "\n" + Utils.throwableToString(t);
        source.getLogger().log(Level.SEVERE, msg, t);
        return result;
    }
}

