/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.BaseObject;

public class BaseFloat
extends BaseObject {
    private static final long serialVersionUID = -3871442214322457039L;

    public BaseFloat() {
        this("0.0");
    }

    public BaseFloat(String s) {
        super(s);
    }

    public BaseFloat(Float value) {
        this(value.toString());
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        try {
            Float.parseFloat(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setValue(String value) {
        if (!this.isValid(value)) {
            return;
        }
        try {
            this.m_Internal = Float.valueOf(Float.parseFloat(value));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_Internal = new Float(0.0);
        }
    }

    @Override
    public String getValue() {
        return ((Float)this.m_Internal).toString();
    }

    public float floatValue() {
        return ((Float)this.m_Internal).floatValue();
    }

    @Override
    public String getTipText() {
        return "A floating point number (from 1.4E-45 to 3.4028235E38).";
    }
}

