/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.BaseObject;

public class BaseInteger
extends BaseObject {
    private static final long serialVersionUID = 4461135181234402629L;

    public BaseInteger() {
        this("0");
    }

    public BaseInteger(String s) {
        super(s);
    }

    public BaseInteger(Integer value) {
        this(value.toString());
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setValue(String value) {
        if (!this.isValid(value)) {
            return;
        }
        try {
            this.m_Internal = Integer.valueOf(Integer.parseInt(value));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_Internal = new Integer(0);
        }
    }

    @Override
    public String getValue() {
        return ((Integer)this.m_Internal).toString();
    }

    public int intValue() {
        return (Integer)this.m_Internal;
    }

    @Override
    public String getTipText() {
        return "An integer (from -2147483648 to 2147483647).";
    }
}

