/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.BaseObject;

public class BaseLong
extends BaseObject {
    private static final long serialVersionUID = 1247725187608799123L;

    public BaseLong() {
        this("0");
    }

    public BaseLong(String s) {
        super(s);
    }

    public BaseLong(Long value) {
        this(value.toString());
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        try {
            Long.parseLong(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setValue(String value) {
        if (!this.isValid(value)) {
            return;
        }
        try {
            this.m_Internal = Long.valueOf(Long.parseLong(value));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_Internal = new Long(0L);
        }
    }

    @Override
    public String getValue() {
        return ((Long)this.m_Internal).toString();
    }

    public long longValue() {
        return (Long)this.m_Internal;
    }

    @Override
    public String getTipText() {
        return "A long (from -9223372036854775808 to 9223372036854775807).";
    }
}

