/*
 * Decompiled with CFR 0.152.
 */
package adams.core.logging;

import adams.core.DateFormat;
import adams.core.Utils;
import adams.core.logging.AbstractLogHandler;
import adams.core.logging.ConsolePanelHandler;
import adams.core.logging.LevelComparator;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingListener;
import adams.core.logging.SimpleConsoleHandler;
import adams.core.option.OptionUtils;
import adams.gui.core.ConsolePanel;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggingHelper {
    public static final String LOGLEVEL_SUFFIX = ".LOGLEVEL";
    protected static final LevelComparator m_LevelComparator = new LevelComparator();
    protected static Handler m_DefaultHandler = new SimpleConsoleHandler();
    protected static DateFormat m_DateFormat = new DateFormat("yyyyMMdd-HHmmss.S");

    public static Level getLevel(Class cls) {
        Level result = Level.WARNING;
        if (System.getenv(cls.getName() + LOGLEVEL_SUFFIX) != null) {
            try {
                result = LoggingLevel.valueOf(System.getenv(cls.getName() + LOGLEVEL_SUFFIX)).getLevel();
            }
            catch (Exception e) {
                result = Level.WARNING;
            }
        }
        return result;
    }

    public static Logger getLogger(Class cls) {
        Logger result = Logger.getLogger(cls.getName());
        result.setLevel(LoggingHelper.getLevel(cls));
        result.removeHandler(m_DefaultHandler);
        result.addHandler(m_DefaultHandler);
        result.setUseParentHandlers(false);
        return result;
    }

    public static Logger getLogger(String name) {
        Logger result = Logger.getLogger(name);
        result.setLevel(Level.WARNING);
        result.removeHandler(m_DefaultHandler);
        result.addHandler(m_DefaultHandler);
        result.setUseParentHandlers(false);
        return result;
    }

    public static Logger getConsoleLogger(Class cls) {
        Logger result = Logger.getLogger(cls.getName());
        result.setLevel(LoggingHelper.getLevel(cls));
        result.addHandler(new SimpleConsoleHandler());
        result.setUseParentHandlers(false);
        return result;
    }

    public static Logger getConsoleLogger(String name) {
        Logger result = Logger.getLogger(name);
        result.setLevel(Level.WARNING);
        result.addHandler(new SimpleConsoleHandler());
        result.setUseParentHandlers(false);
        return result;
    }

    public static boolean isAtLeast(Logger logger, Level levelMin) {
        return LoggingHelper.isAtLeast(logger.getLevel(), levelMin);
    }

    public static boolean isAtLeast(Level level, Level levelMin) {
        return m_LevelComparator.compare(level, levelMin) >= 0;
    }

    public static boolean isAtMost(Logger logger, Level levelMax) {
        return LoggingHelper.isAtMost(logger.getLevel(), levelMax);
    }

    public static boolean isAtMost(Level level, Level levelMax) {
        return m_LevelComparator.compare(level, levelMax) <= 0;
    }

    public static void setDefaultHandler(Handler value) {
        Handler old = m_DefaultHandler;
        HashSet<LoggingListener> listeners = new HashSet<LoggingListener>();
        if (old instanceof AbstractLogHandler) {
            listeners.addAll(((AbstractLogHandler)old).loggingListeners());
        }
        m_DefaultHandler = value;
        if (listeners.size() > 0) {
            if (m_DefaultHandler instanceof AbstractLogHandler) {
                for (LoggingListener l : listeners) {
                    ((AbstractLogHandler)m_DefaultHandler).addLoggingListener(l);
                }
            }
            ((AbstractLogHandler)old).removeLoggingListeners();
        }
        LogManager manager = LogManager.getLogManager();
        Enumeration<String> names = manager.getLoggerNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            Logger logger = manager.getLogger(name);
            if (logger == null) continue;
            logger.removeHandler(old);
            logger.removeHandler(m_DefaultHandler);
            logger.addHandler(m_DefaultHandler);
        }
    }

    public static Handler getDefaultHandler() {
        return m_DefaultHandler;
    }

    public static boolean useHandlerFromOptions(String[] options) {
        boolean result = false;
        String classname = OptionUtils.removeOption(options, "-logging-handler");
        if (classname != null) {
            try {
                Handler handler = (Handler)Class.forName(classname).newInstance();
                LoggingHelper.setDefaultHandler(handler);
                result = true;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate logging handler: " + classname);
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void outputHandlerOption() {
        System.out.println("-logging-handler <classname>");
        System.out.println("\tlogging handler to use");
        System.out.println("\tdefault: " + ConsolePanelHandler.class.getName());
    }

    public static ConsolePanel.OutputType levelToOutputType(Level level) {
        if (level == Level.SEVERE || level == Level.WARNING) {
            return ConsolePanel.OutputType.ERROR;
        }
        if (level == Level.INFO || level == Level.CONFIG) {
            return ConsolePanel.OutputType.INFO;
        }
        return ConsolePanel.OutputType.DEBUG;
    }

    public static StringBuilder assembleMessage(LogRecord record) {
        String suffix;
        String msg = record.getMessage() + "\n";
        if (record.getThrown() != null) {
            msg = msg + Utils.throwableToString(record.getThrown()) + "\n";
        }
        StringBuilder result = new StringBuilder();
        String[] lines = msg.split("\n");
        ConsolePanel.OutputType type = LoggingHelper.levelToOutputType(record.getLevel());
        String prefix = record.getLoggerName();
        switch (type) {
            case INFO: {
                suffix = "-INFO";
                break;
            }
            case ERROR: {
                suffix = "-ERROR";
                break;
            }
            case DEBUG: {
                suffix = "-DEBUG";
                break;
            }
            default: {
                suffix = "";
            }
        }
        String actualPrefix = prefix.length() > 0 ? "[" + prefix + suffix + "/" + m_DateFormat.format(new Date()) + "] " : "";
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                result.append("\n");
            }
            result.append(actualPrefix);
            result.append(lines[i]);
        }
        lines = null;
        return result;
    }
}

