/*
 * Decompiled with CFR 0.152.
 */
package adams.core.logging;

import adams.core.SizeOf;
import adams.core.SizeOfHandler;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingSupporter;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingObject
implements Serializable,
SizeOfHandler,
LoggingSupporter {
    private static final long serialVersionUID = 2530679166402508994L;
    protected LoggingLevel m_LoggingLevel;
    protected transient Logger m_Logger;

    public LoggingObject() {
        this.initializeLogging();
    }

    protected void initializeLogging() {
        this.m_LoggingLevel = LoggingLevel.WARNING;
    }

    protected void configureLogger() {
        this.m_Logger = LoggingHelper.getLogger(this.getClass());
        this.m_Logger.setLevel(this.m_LoggingLevel.getLevel());
    }

    @Override
    public synchronized Logger getLogger() {
        if (this.m_Logger == null) {
            this.configureLogger();
        }
        return this.m_Logger;
    }

    public LoggingLevel getLoggingLevel() {
        return this.m_LoggingLevel;
    }

    @Override
    public boolean isLoggingEnabled() {
        return LoggingHelper.isAtLeast(this.m_LoggingLevel.getLevel(), Level.CONFIG);
    }

    @Override
    public int sizeOf() {
        return SizeOf.sizeOf(this);
    }
}

