/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.License;
import adams.core.Utils;
import adams.core.annotation.MixedCopyright;

public class HtmlUtils {
    public static final String DEFAULT_MARKUP = "<a href=\"$0\">$0</a>";

    public static String toHTML(String s) {
        if (s == null) {
            return "";
        }
        String result = s;
        result = result.replaceAll("&", "&amp;");
        result = result.replaceAll("<", "&lt;");
        result = result.replaceAll(">", "&gt;");
        result = result.replaceAll("@", "&#64;");
        result = result.replaceAll("/", "&#47;");
        return result;
    }

    public static String convertLines(String s, boolean nbsp) {
        String result = s;
        result = result.replace("\n", "<br>\n");
        if (nbsp) {
            Object[] lines = result.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                boolean first = true;
                StringBuilder newLine = new StringBuilder();
                for (int n = 0; n < ((String)lines[i]).length(); ++n) {
                    if (first) {
                        if (((String)lines[i]).charAt(n) == ' ') {
                            newLine.append("&#160;");
                            continue;
                        }
                        first = false;
                        newLine.append(((String)lines[i]).charAt(n));
                        continue;
                    }
                    newLine.append(((String)lines[i]).charAt(n));
                }
                lines[i] = newLine.toString();
            }
            result = Utils.flatten(lines, "\n");
        }
        return result;
    }

    public static String fromHTML(String s) {
        String result = s;
        result = result.replaceAll("&lt;", "<");
        result = result.replaceAll("&gt;", ">");
        result = result.replaceAll("&#64;", "@");
        result = result.replaceAll("&#47;", "/");
        result = result.replaceAll("&amp;", "&");
        return result;
    }

    public static String markUpURLs(String raw, boolean toHtml) {
        return HtmlUtils.markUpURLs(raw, DEFAULT_MARKUP, toHtml);
    }

    @MixedCopyright(author="Sergio Nunes", url="http://stackoverflow.com/a/7122165", license=License.CC_BY_SA_3)
    public static String markUpURLs(String raw, String replacement, boolean toHtml) {
        if (raw == null) {
            return null;
        }
        String result = raw;
        if (toHtml) {
            result = result.replaceAll("<", "&lt;");
            result = result.replaceAll(">", "&gt;");
        }
        result = result.replaceAll("(?:https?|ftps?)://[\\w/%.-][/\\??\\w=?\\w?/%.-]?[/\\?#&\\w=?\\w?/%.-]*", replacement);
        return result;
    }
}

