/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.Properties;
import adams.env.Environment;
import java.util.HashMap;

public class Conversion {
    public static final String FILENAME = "Conversion.props";
    public static final String KEY_RENAME = "Rename";
    public static final String KEY_PARTIAL_RENAME = "PartialRename";
    public static final String KEY_RENAME_OPTION = "RenameOption";
    public static final String KEY_RENAME_PROPERTY = "RenameProperty";
    protected static Properties m_Properties;
    protected static HashMap<String, String> m_Mapping;
    protected static HashMap<String, String> m_MappingPartial;
    protected static HashMap<String, HashMap<String, String>> m_MappingOption;
    protected static HashMap<String, HashMap<String, String>> m_MappingProperty;

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("conversion");
        }
        return m_Properties;
    }

    protected static synchronized void initMappings() {
        if (m_Mapping == null) {
            String[] parts;
            int i;
            Properties props = Conversion.getProperties();
            String[] keys = props.getPath(KEY_RENAME, "").split(",");
            m_Mapping = new HashMap();
            if (keys.length >= 1 && keys[0].length() != 0) {
                for (i = 0; i < keys.length; ++i) {
                    if (!props.hasKey(keys[i])) {
                        System.err.println("Rename mapping '" + keys[i] + "' not found - skipped!");
                        continue;
                    }
                    parts = props.getPath(keys[i], "").split("-");
                    if (parts.length != 2) {
                        System.err.println("Wrong format for rename mapping ('" + keys[i] + "'): " + props.getProperty(keys[i]));
                        continue;
                    }
                    m_Mapping.put(parts[0], parts[1]);
                }
            }
            keys = props.getPath(KEY_PARTIAL_RENAME, "").split(",");
            m_MappingPartial = new HashMap();
            if (keys.length >= 1 && keys[0].length() != 0) {
                for (i = 0; i < keys.length; ++i) {
                    if (!props.hasKey(keys[i])) {
                        System.err.println("Partial renaming '" + keys[i] + "' not found - skipped!");
                        continue;
                    }
                    parts = props.getPath(keys[i], "").split("\t");
                    if (parts.length != 2) {
                        System.err.println("Wrong format for partial renaming ('" + keys[i] + "'): " + props.getProperty(keys[i]));
                        continue;
                    }
                    m_MappingPartial.put(parts[0], parts[1]);
                }
            }
            keys = props.getPath(KEY_RENAME_OPTION, "").split(",");
            m_MappingOption = new HashMap();
            if (keys.length >= 1 && keys[0].length() != 0) {
                for (i = 0; i < keys.length; ++i) {
                    if (!props.hasKey(keys[i])) {
                        System.err.println("Option renaming '" + keys[i] + "' not found - skipped!");
                        continue;
                    }
                    parts = props.getPath(keys[i], "").split("#");
                    if (parts.length != 3) {
                        System.err.println("Wrong format for option renaming ('" + keys[i] + "'): " + props.getProperty(keys[i]));
                        continue;
                    }
                    if (!m_MappingOption.containsKey(parts[0])) {
                        m_MappingOption.put(parts[0], new HashMap());
                    }
                    m_MappingOption.get(parts[0]).put(parts[1], parts[2]);
                }
            }
            keys = props.getPath(KEY_RENAME_PROPERTY, "").split(",");
            m_MappingProperty = new HashMap();
            if (keys.length >= 1 && keys[0].length() != 0) {
                for (i = 0; i < keys.length; ++i) {
                    if (!props.hasKey(keys[i])) {
                        System.err.println("Property renaming '" + keys[i] + "' not found - skipped!");
                        continue;
                    }
                    parts = props.getPath(keys[i], "").split("#");
                    if (parts.length != 3) {
                        System.err.println("Wrong format for property renaming ('" + keys[i] + "'): " + props.getProperty(keys[i]));
                        continue;
                    }
                    if (!m_MappingProperty.containsKey(parts[0])) {
                        m_MappingProperty.put(parts[0], new HashMap());
                    }
                    m_MappingProperty.get(parts[0]).put(parts[1], parts[2]);
                }
            }
        }
    }

    public static synchronized String rename(String classname) {
        String result = classname;
        Conversion.initMappings();
        while (m_Mapping.containsKey(result)) {
            result = m_Mapping.get(result);
        }
        for (String key : m_MappingPartial.keySet()) {
            result = result.replace(key, m_MappingPartial.get(key));
        }
        return result;
    }

    public static synchronized String renameOption(String classname, String option) {
        String result = option;
        boolean dash = option.startsWith("-");
        Conversion.initMappings();
        if (dash) {
            option = option.substring(1);
        }
        if (m_MappingOption.containsKey(classname) && m_MappingOption.get(classname).containsKey(option)) {
            result = dash ? "-" + m_MappingOption.get(classname).get(option) : m_MappingOption.get(classname).get(option);
        }
        return result;
    }

    public static synchronized String renameProperty(String classname, String property) {
        String result = property;
        Conversion.initMappings();
        if (m_MappingProperty.containsKey(classname) && m_MappingProperty.get(classname).containsKey(property)) {
            result = m_MappingProperty.get(classname).get(property);
        }
        return result;
    }
}

