/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.option.AbstractArgumentOption;
import adams.core.option.ArrayProducer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.AbstractActor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class MaterializedArrayProducer
extends ArrayProducer {
    private static final long serialVersionUID = -1441936327738738725L;
    protected CallableActorHelper m_Helper;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    @Override
    protected OptionHandler checkInput(OptionHandler object) {
        if (object instanceof AbstractActor) {
            return object;
        }
        throw new IllegalArgumentException("Input needs to be derived from " + AbstractActor.class.getName() + "!");
    }

    protected String materialize(CallableActorReference ref) {
        String result = null;
        AbstractActor actor = this.m_Helper.findCallableActorRecursive((AbstractActor)this.m_Input, ref);
        result = actor != null ? OptionUtils.getCommandLine(actor) : "Failed to locate/process global reference '" + ref + "'!";
        return result;
    }

    @Override
    public ArrayList<String> processOption(AbstractArgumentOption option) {
        ArrayList<String> result;
        if (option.isVariableAttached() && !this.m_OutputVariableValues || option.getBaseClass() != CallableActorReference.class) {
            result = super.processOption(option);
        } else {
            result = new ArrayList<String>();
            Object currValue = this.getCurrentValue(option);
            Object currValues = null;
            if (currValue != null) {
                if (!option.isMultiple()) {
                    currValues = Array.newInstance(option.getBaseClass(), 1);
                    Array.set(currValues, 0, currValue);
                } else {
                    currValues = currValue;
                }
                for (int i = 0; i < Array.getLength(currValues); ++i) {
                    result.add(this.getOptionIdentifier(option));
                    result.add(this.materialize((CallableActorReference)Array.get(currValues, i)));
                }
            }
            if (this.m_Nesting.empty()) {
                this.m_OutputList.addAll(result);
            } else {
                ((ArrayList)this.m_Nesting.peek()).addAll(result);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        MaterializedArrayProducer.runProducer(MaterializedArrayProducer.class, args);
    }
}

