/*
 * Decompiled with CFR 0.152.
 */
package adams.data.baseline;

import adams.data.baseline.AbstractBaselineCorrection;
import adams.data.baseline.AbstractDatabaseConnectionBaselineCorrection;
import adams.data.baseline.PassThrough;
import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import java.util.List;

public class SlidingWindow<T extends DataContainer>
extends AbstractDatabaseConnectionBaselineCorrection<T> {
    private static final long serialVersionUID = -3975367203680893657L;
    protected int m_NumLeft;
    protected int m_NumRight;
    protected AbstractBaselineCorrection m_BaselineCorrection;

    @Override
    public String globalInfo() {
        return "Applies a baseline correction scheme on partitions of the data with a sliding window approach.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-left", "numLeft", 30);
        this.m_OptionManager.add("num-right", "numRight", 30);
        this.m_OptionManager.add("baseline", "baselineCorrection", new PassThrough());
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    public void setNumLeft(int value) {
        if (value > 0) {
            this.m_NumLeft = value;
            this.reset();
        } else {
            this.getLogger().severe("At least one point is required!");
        }
    }

    public int getNumLeft() {
        return this.m_NumLeft;
    }

    public String numLeftTipText() {
        return "The number of points left of the center point.";
    }

    public void setNumRight(int value) {
        if (value > 0) {
            this.m_NumRight = value;
            this.reset();
        } else {
            this.getLogger().severe("At least one point is required!");
        }
    }

    public int getNumRight() {
        return this.m_NumRight;
    }

    public String numRightTipText() {
        return "The number of points right of the center point.";
    }

    public void setBaselineCorrection(AbstractBaselineCorrection value) {
        this.m_BaselineCorrection = value;
        this.updateDatabaseConnection();
        this.reset();
    }

    public AbstractBaselineCorrection getBaselineCorrection() {
        return this.m_BaselineCorrection;
    }

    public String baselineCorrectionTipText() {
        return "The baseline correction algorithm to use for correcting the baseline of the data.";
    }

    @Override
    protected void updateDatabaseConnection() {
        if (this.m_BaselineCorrection instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)((Object)this.m_BaselineCorrection)).setDatabaseConnection(this.getDatabaseConnection());
        }
    }

    @Override
    protected T processData(T data) {
        DataContainer result = data.getHeader();
        AbstractBaselineCorrection correction = this.m_BaselineCorrection.shallowCopy(true);
        List points = data.toList();
        DataContainer window = data.getHeader();
        for (int i = 0; i < points.size(); ++i) {
            int right;
            int left = i;
            if (left > this.m_NumLeft) {
                left = this.m_NumLeft;
            }
            if ((right = points.size() - i - 1) > this.m_NumRight) {
                right = this.m_NumRight;
            }
            int size = left + 1 + right;
            window.clear();
            for (int n = 0; n < size; ++n) {
                window.add(((DataPoint)points.get(i - left + n)).getClone());
            }
            DataContainer windowCorr = correction.correct(window);
            if (windowCorr.size() != size) {
                throw new IllegalStateException("Baseline correction scheme returned different number of points (expected/actual): " + size + " != " + windowCorr.size());
            }
            result.add(((DataPoint)windowCorr.toList().get(left)).getClone());
        }
        correction.cleanUp();
        return (T)result;
    }
}

