/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.ShallowCopySupporter;
import adams.core.io.FileFormatHandler;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.data.container.DataContainer;
import adams.data.io.input.IncrementalDataContainerReader;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDataContainerReader<T extends DataContainer>
extends AbstractOptionHandler
implements Comparable,
CleanUpHandler,
ShallowCopySupporter<AbstractDataContainerReader>,
FileFormatHandler {
    private static final long serialVersionUID = -4690065186988048507L;
    protected PlaceholderFile m_Input;
    protected boolean m_CreateDummyReport;
    protected List<T> m_ReadData;
    protected boolean m_Processed;
    protected boolean m_InputIsFile;

    @Override
    public abstract String getFormatDescription();

    @Override
    public abstract String[] getFormatExtensions();

    @Override
    public String getDefaultFormatExtension() {
        return this.getFormatExtensions()[0];
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ReadData = new ArrayList<T>();
        this.m_InputIsFile = true;
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_ReadData = new ArrayList<T>();
        this.m_Processed = false;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("input", "input", new PlaceholderFile("."));
        this.m_OptionManager.add("create-dummy-report", "createDummyReport", false);
    }

    public boolean isInputFile() {
        return this.m_InputIsFile;
    }

    public void setInput(PlaceholderFile value) {
        this.m_Input = value == null ? new PlaceholderFile(".") : value;
        this.reset();
    }

    public PlaceholderFile getInput() {
        return this.m_Input;
    }

    public String inputTipText() {
        if (this.m_InputIsFile) {
            return "The file to read and turn into a container.";
        }
        return "The directory to read and turn into a container.";
    }

    public void setCreateDummyReport(boolean value) {
        this.m_CreateDummyReport = value;
        this.reset();
    }

    public boolean getCreateDummyReport() {
        return this.m_CreateDummyReport;
    }

    public String createDummyReportTipText() {
        return "If true, then a dummy report is created if none present.";
    }

    public List<T> read() {
        if (this instanceof IncrementalDataContainerReader) {
            this.m_ReadData.clear();
            if (!this.m_Processed || ((IncrementalDataContainerReader)((Object)this)).hasMoreData()) {
                return this.doRead();
            }
            return this.m_ReadData;
        }
        if (!this.m_Processed) {
            return this.doRead();
        }
        return this.m_ReadData;
    }

    protected List<T> doRead() {
        if (!this.m_Processed) {
            this.checkData();
        }
        this.readData();
        this.postProcessData();
        this.m_Processed = true;
        return this.m_ReadData;
    }

    protected void checkData() {
        if (this.m_InputIsFile) {
            if (!this.m_Input.exists()) {
                throw new IllegalStateException("Input file '" + this.m_Input + "' does not exist!");
            }
            if (this.m_Input.isDirectory()) {
                throw new IllegalStateException("No input file but directory provided ('" + this.m_Input + "')!");
            }
        } else {
            if (!this.m_Input.exists()) {
                throw new IllegalStateException("Input directory '" + this.m_Input + "' does not exist!");
            }
            if (!this.m_Input.isDirectory()) {
                throw new IllegalStateException("No input directory but file provided ('" + this.m_Input + "')!");
            }
        }
    }

    protected abstract void readData();

    protected void postProcessData() {
        if (this.m_CreateDummyReport) {
            for (int i = 0; i < this.m_ReadData.size(); ++i) {
                MutableReportHandler handler;
                DataContainer cont = (DataContainer)this.m_ReadData.get(i);
                if (!(cont instanceof MutableReportHandler) || (handler = (MutableReportHandler)((Object)cont)).hasReport()) continue;
                handler.setReport(this.createDummyReport(cont));
            }
        }
    }

    protected Report createDummyReport(T cont) {
        return null;
    }

    @Override
    public void cleanUp() {
        this.reset();
    }

    @Override
    public void destroy() {
        this.cleanUp();
        super.destroy();
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public AbstractDataContainerReader shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractDataContainerReader shallowCopy(boolean expand) {
        return (AbstractDataContainerReader)OptionUtils.shallowCopy(this, expand);
    }

    public static String[] getReaders() {
        return ClassLister.getSingleton().getClassnames(AbstractDataContainerReader.class);
    }

    public static AbstractDataContainerReader forName(String classname, String[] options) {
        AbstractDataContainerReader result;
        try {
            result = (AbstractDataContainerReader)OptionUtils.forName(AbstractDataContainerReader.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractDataContainerReader forCommandLine(String cmdline) {
        return (AbstractDataContainerReader)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

