/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.data.io.input.AbstractTextReader;
import java.util.ArrayList;
import java.util.logging.Level;

public class LineArrayTextReader
extends AbstractTextReader<String[]> {
    private static final long serialVersionUID = -4772416995579481937L;
    protected int m_ChunkSize;

    @Override
    public String globalInfo() {
        return "Reads the text in as array of strings (each line is an array element).\nFor large files, the data can be 'chunked' (ie outputting it in blocks).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("chunk-size", "chunkSize", -1, -1, null);
    }

    public void setChunkSize(int value) {
        if (value < 1) {
            value = -1;
        }
        this.m_ChunkSize = value;
        this.reset();
    }

    public int getChunkSize() {
        return this.m_ChunkSize;
    }

    public String chunkSizeTipText() {
        return "The maximum number of lines per chunk; using -1 will read put all data into a single array.";
    }

    @Override
    public Class generates() {
        return String[].class;
    }

    @Override
    public String[] doNext() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line;
            while ((line = this.m_Reader.readLine()) != null) {
                result.add(line);
                if (this.m_ChunkSize <= -1 || result.size() < this.m_ChunkSize) continue;
            }
            if (line == null) {
                this.m_Reader = null;
            }
            if (this.m_ChunkSize == -1) {
                this.m_Reader = null;
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to read from reader!", e);
            return null;
        }
        return result.toArray(new String[result.size()]);
    }
}

