/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.core.Utils;
import java.util.Arrays;

public class StatUtils {
    public static Number[] toNumberArray(byte[] array) {
        Number[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Byte(array[i]);
        }
        return result;
    }

    public static Number[] toNumberArray(short[] array) {
        Number[] result = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Short(array[i]);
        }
        return result;
    }

    public static Number[] toNumberArray(int[] array) {
        Number[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Integer(array[i]);
        }
        return result;
    }

    public static Number[] toNumberArray(long[] array) {
        Number[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Long(array[i]);
        }
        return result;
    }

    public static Number[] toNumberArray(float[] array) {
        Number[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Float(array[i]);
        }
        return result;
    }

    public static Number[] toNumberArray(double[] array) {
        Number[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Double(array[i]);
        }
        return result;
    }

    public static byte[] toByteArray(Number[] array) {
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].byteValue();
        }
        return result;
    }

    public static short[] toShortArray(Number[] array) {
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].shortValue();
        }
        return result;
    }

    public static int[] toIntArray(Number[] array) {
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].intValue();
        }
        return result;
    }

    public static long[] toLongArray(Number[] array) {
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].longValue();
        }
        return result;
    }

    public static float[] toFloatArray(Number[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].floatValue();
        }
        return result;
    }

    public static double[] toDoubleArray(Number[] array) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].doubleValue();
        }
        return result;
    }

    public static int minIndex(Number[] array) {
        int result = -1;
        double minValue = Double.MAX_VALUE;
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i].doubleValue() < minValue)) continue;
            minValue = array[i].doubleValue();
            result = i;
        }
        return result;
    }

    public static int minIndex(int[] array) {
        return StatUtils.minIndex(StatUtils.toNumberArray(array));
    }

    public static int minIndex(double[] array) {
        return StatUtils.minIndex(StatUtils.toNumberArray(array));
    }

    public static Number min(Number[] array) {
        int index = StatUtils.minIndex(array);
        if (index == -1) {
            return null;
        }
        return array[index];
    }

    public static int min(int[] array) {
        Integer result = (Integer)StatUtils.min(StatUtils.toNumberArray(array));
        if (result == null) {
            return Integer.MIN_VALUE;
        }
        return result;
    }

    public static double min(double[] array) {
        Double result = (Double)StatUtils.min(StatUtils.toNumberArray(array));
        if (result == null) {
            return -1.7976931348623157E308;
        }
        return result;
    }

    public static int maxIndex(Number[] array) {
        int result = -1;
        double maxValue = -1.7976931348623157E308;
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i].doubleValue() > maxValue)) continue;
            maxValue = array[i].doubleValue();
            result = i;
        }
        return result;
    }

    public static int maxIndex(int[] array) {
        return StatUtils.maxIndex(StatUtils.toNumberArray(array));
    }

    public static int maxIndex(double[] array) {
        return StatUtils.maxIndex(StatUtils.toNumberArray(array));
    }

    public static Number max(Number[] array) {
        int index = StatUtils.maxIndex(array);
        if (index == -1) {
            return null;
        }
        return array[index];
    }

    public static int max(int[] array) {
        Integer result = (Integer)StatUtils.max(StatUtils.toNumberArray(array));
        if (result == null) {
            return Integer.MAX_VALUE;
        }
        return result;
    }

    public static double max(double[] array) {
        Double result = (Double)StatUtils.max(StatUtils.toNumberArray(array));
        if (result == null) {
            return Double.MAX_VALUE;
        }
        return result;
    }

    public static double mean(Number[] array) {
        if (array.length == 0) {
            return Double.NaN;
        }
        double result = 0.0;
        for (int i = 0; i < array.length; ++i) {
            result += array[i].doubleValue();
        }
        return result /= (double)array.length;
    }

    public static double mean(int[] array) {
        return StatUtils.mean(StatUtils.toNumberArray(array));
    }

    public static double mean(double[] array) {
        return StatUtils.mean(StatUtils.toNumberArray(array));
    }

    public static double iqr(double[] array) {
        return StatUtils.iqr(StatUtils.toNumberArray(array));
    }

    public static double iqr(int[] array) {
        return StatUtils.iqr(StatUtils.toNumberArray(array));
    }

    public static double iqr(Number[] array) {
        if (array.length == 0) {
            return Double.NaN;
        }
        Object[] sorted = (Number[])array.clone();
        Arrays.sort(sorted);
        double iqr1 = ((Number)sorted[(int)((double)sorted.length * 0.25)]).doubleValue();
        double iqr3 = ((Number)sorted[(int)((double)sorted.length * 0.75)]).doubleValue();
        return iqr3 - iqr1;
    }

    public static double median(Number[] array) {
        if (array.length == 0) {
            return Double.NaN;
        }
        Object[] sorted = (Number[])array.clone();
        Arrays.sort(sorted);
        double result = sorted.length % 2 == 0 ? (((Number)sorted[sorted.length / 2 - 1]).doubleValue() + ((Number)sorted[sorted.length / 2]).doubleValue()) / 2.0 : ((Number)sorted[sorted.length / 2]).doubleValue();
        return result;
    }

    public static double median(int[] array) {
        return StatUtils.median(StatUtils.toNumberArray(array));
    }

    public static double median(double[] array) {
        return StatUtils.median(StatUtils.toNumberArray(array));
    }

    public static double stddev(Number[] array, boolean isSample) {
        if (array.length == 0) {
            return Double.NaN;
        }
        double result = 0.0;
        double mean = StatUtils.mean(array);
        for (int i = 0; i < array.length; ++i) {
            result += Math.pow(array[i].doubleValue() - mean, 2.0);
        }
        result = isSample ? (result /= (double)(array.length - 1)) : (result /= (double)array.length);
        result = Math.sqrt(result);
        return result;
    }

    public static double stddev(int[] array, boolean isSample) {
        return StatUtils.stddev(StatUtils.toNumberArray(array), isSample);
    }

    public static double stddev(double[] array, boolean isSample) {
        return StatUtils.stddev(StatUtils.toNumberArray(array), isSample);
    }

    public static Double[] normalize(Number[] array) {
        int i;
        Double[] result = new Double[array.length];
        double sum = 0.0;
        for (i = 0; i < array.length; ++i) {
            sum += array[i].doubleValue();
        }
        if (sum > 0.0) {
            for (i = 0; i < array.length; ++i) {
                result[i] = array[i].doubleValue() / sum;
            }
        } else {
            result = null;
        }
        return result;
    }

    public static double[] normalize(int[] array) {
        return StatUtils.toDoubleArray(StatUtils.normalize(StatUtils.toNumberArray(array)));
    }

    public static double[] normalize(double[] array) {
        return StatUtils.toDoubleArray(StatUtils.normalize(StatUtils.toNumberArray(array)));
    }

    public static Double[] standardize(Number[] array, boolean isSample) {
        Double[] result = new Double[array.length];
        double mean = StatUtils.mean(array);
        double stddev = StatUtils.stddev(array, isSample);
        if (stddev == 0.0) {
            return null;
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = (array[i].doubleValue() - mean) / stddev;
        }
        return result;
    }

    public static double[] standardize(double[] array, boolean isSample) {
        return StatUtils.toDoubleArray(StatUtils.standardize(StatUtils.toNumberArray(array), isSample));
    }

    public static double[] standardize(int[] array, boolean isSample) {
        return StatUtils.toDoubleArray(StatUtils.standardize(StatUtils.toNumberArray(array), isSample));
    }

    public static double sum(Number[] array) {
        double result = 0.0;
        for (int i = 0; i < array.length; ++i) {
            result += array[i].doubleValue();
        }
        return result;
    }

    public static double sum(int[] array) {
        return StatUtils.sum(StatUtils.toNumberArray(array));
    }

    public static double sum(double[] array) {
        return StatUtils.sum(StatUtils.toNumberArray(array));
    }

    public static Number[] sort(Number[] array) {
        return StatUtils.sort(array, true);
    }

    public static int[] sort(int[] array) {
        return StatUtils.sort(array, true);
    }

    public static double[] sort(double[] array) {
        return StatUtils.sort(array, true);
    }

    public static Number[] sort(Number[] array, boolean asc) {
        Object[] sorted = (Number[])array.clone();
        Arrays.sort(sorted);
        if (!asc) {
            for (int i = 0; i < array.length / 2; ++i) {
                int n = sorted.length - i - 1;
                Object value = sorted[i];
                sorted[i] = sorted[n];
                sorted[n] = value;
            }
        }
        return sorted;
    }

    public static int[] sort(int[] array, boolean asc) {
        Integer[] sorted = (Integer[])StatUtils.sort(StatUtils.toNumberArray(array), asc);
        int[] result = new int[sorted.length];
        for (int i = 0; i < sorted.length; ++i) {
            result[i] = sorted[i];
        }
        return result;
    }

    public static double[] sort(double[] array, boolean asc) {
        Double[] sorted = (Double[])StatUtils.sort(StatUtils.toNumberArray(array), asc);
        double[] result = new double[sorted.length];
        for (int i = 0; i < sorted.length; ++i) {
            result[i] = sorted[i];
        }
        return result;
    }

    public static int findFirst(Number[] array, Number toFind) {
        int result = -1;
        for (int i = 0; i < array.length; ++i) {
            if (!toFind.equals(array[i])) continue;
            result = i;
            break;
        }
        return result;
    }

    public static int findFirst(int[] array, int toFind) {
        return StatUtils.findFirst(StatUtils.toNumberArray(array), new Integer(toFind));
    }

    public static int findFirst(double[] array, double toFind) {
        return StatUtils.findFirst(StatUtils.toNumberArray(array), new Double(toFind));
    }

    public static int findClosest(Number[] array, Number toFind) {
        int result = -1;
        double diff = Double.MAX_VALUE;
        for (int i = 0; i < array.length; ++i) {
            double newDiff = Math.abs(array[i].doubleValue() - toFind.doubleValue());
            if (!(newDiff < diff)) continue;
            diff = newDiff;
            result = i;
        }
        return result;
    }

    public static int findClosest(int[] array, int toFind) {
        return StatUtils.findClosest(StatUtils.toNumberArray(array), new Integer(toFind));
    }

    public static int findClosest(double[] array, double toFind) {
        return StatUtils.findClosest(StatUtils.toNumberArray(array), new Double(toFind));
    }

    public static double correlationCoefficient(double[] y1, double[] y2) {
        return StatUtils.correlationCoefficient(StatUtils.toNumberArray(y1), StatUtils.toNumberArray(y2));
    }

    public static double correlationCoefficient(Number[] y1, Number[] y2) {
        double c;
        if (y1.length != y2.length) {
            throw new IllegalArgumentException("Arrays differ in length: " + y1.length + " != " + y2.length);
        }
        int n = y1.length;
        double av1 = 0.0;
        double av2 = 0.0;
        double y11 = 0.0;
        double y22 = 0.0;
        double y12 = 0.0;
        if (y1.length <= 1) {
            c = 1.0;
        } else {
            int i;
            for (i = 0; i < n; ++i) {
                av1 += y1[i].doubleValue();
                av2 += y2[i].doubleValue();
            }
            av1 /= (double)n;
            av2 /= (double)n;
            for (i = 0; i < n; ++i) {
                y11 += (y1[i].doubleValue() - av1) * (y1[i].doubleValue() - av1);
                y22 += (y2[i].doubleValue() - av2) * (y2[i].doubleValue() - av2);
                y12 += (y1[i].doubleValue() - av1) * (y2[i].doubleValue() - av2);
            }
            c = y11 == 0.0 && y22 == 0.0 ? 1.0 : (y11 == 0.0 || y22 == 0.0 ? 0.0 : y12 / Math.sqrt(Math.abs(y11 * y22)));
        }
        return c;
    }

    public static double rmse(double[] actual, double[] predicted) {
        return StatUtils.rmse(StatUtils.toNumberArray(actual), StatUtils.toNumberArray(predicted));
    }

    public static double rmse(Number[] actual, Number[] predicted) {
        if (actual.length != predicted.length) {
            throw new IllegalArgumentException("Arrays differ in length: " + actual.length + " != " + predicted.length);
        }
        double result = 0.0;
        for (int i = 0; i < predicted.length; ++i) {
            result += Math.pow(predicted[i].doubleValue() - actual[i].doubleValue(), 2.0);
        }
        result /= (double)predicted.length;
        result = Math.sqrt(result);
        return result;
    }

    public static double mae(double[] actual, double[] predicted) {
        return StatUtils.mae(StatUtils.toNumberArray(actual), StatUtils.toNumberArray(predicted));
    }

    public static double mae(Number[] actual, Number[] predicted) {
        if (actual.length != predicted.length) {
            throw new IllegalArgumentException("Arrays differ in length: " + actual.length + " != " + predicted.length);
        }
        double result = 0.0;
        for (int i = 0; i < predicted.length; ++i) {
            result += Math.abs(predicted[i].doubleValue() - actual[i].doubleValue());
        }
        return result /= (double)predicted.length;
    }

    public static double rae(double[] actual, double[] predicted) {
        return StatUtils.rae(StatUtils.toNumberArray(actual), StatUtils.toNumberArray(predicted));
    }

    public static double rae(Number[] actual, Number[] predicted) {
        if (actual.length != predicted.length) {
            throw new IllegalArgumentException("Arrays differ in length: " + actual.length + " != " + predicted.length);
        }
        double pred = 0.0;
        double act = 0.0;
        double actMean = StatUtils.mean(actual);
        for (int i = 0; i < predicted.length; ++i) {
            pred += Math.abs(predicted[i].doubleValue() - actual[i].doubleValue());
            act += Math.abs(actual[i].doubleValue() - actMean);
        }
        double result = act == 0.0 ? Double.NaN : pred / act;
        return result;
    }

    public static double rrse(double[] actual, double[] predicted) {
        return StatUtils.rrse(StatUtils.toNumberArray(actual), StatUtils.toNumberArray(predicted));
    }

    public static double rrse(Number[] actual, Number[] predicted) {
        if (actual.length != predicted.length) {
            throw new IllegalArgumentException("Arrays differ in length: " + actual.length + " != " + predicted.length);
        }
        double pred = 0.0;
        double act = 0.0;
        double actMean = StatUtils.mean(actual);
        for (int i = 0; i < predicted.length; ++i) {
            pred += Math.pow(predicted[i].doubleValue() - actual[i].doubleValue(), 2.0);
            act += Math.pow(actual[i].doubleValue() - actMean, 2.0);
        }
        double result = act == 0.0 ? Double.NaN : Math.sqrt(pred / act);
        return result;
    }

    public static double[] standardScores(double[] x, boolean isSample) {
        Number[] n = StatUtils.toNumberArray(x);
        return StatUtils.standardScores(n, n, isSample);
    }

    public static double[] standardScores(Number[] x, boolean isSample) {
        return StatUtils.standardScores(x, x, isSample);
    }

    public static double[] standardScores(double[] actual, double[] predicted, boolean isSample) {
        return StatUtils.standardScores(StatUtils.toNumberArray(actual), StatUtils.toNumberArray(predicted), isSample);
    }

    public static double[] standardScores(Number[] actual, Number[] predicted, boolean isSample) {
        if (actual.length != predicted.length) {
            throw new IllegalArgumentException("Arrays differ in length: " + actual.length + " != " + predicted.length);
        }
        double[] result = new double[actual.length];
        double actMean = StatUtils.mean(actual);
        double actStdev = StatUtils.stddev(actual, isSample);
        for (int i = 0; i < predicted.length; ++i) {
            result[i] = actStdev == 0.0 ? Double.NaN : (predicted[i].doubleValue() - actMean) / actStdev;
        }
        return result;
    }

    public static double signalToNoiseRatio(Number[] x) {
        return StatUtils.mean(x) / StatUtils.stddev(x, true);
    }

    public static double signalToNoiseRatio(double[] x) {
        return StatUtils.mean(x) / StatUtils.stddev(x, true);
    }

    public static void main(String[] args) {
        Number[] array = new Double[]{12.0, 3.2, 2.0, 6.0, -1.0, 99.0};
        System.out.println("array: " + Utils.arrayToString(array));
        System.out.println("sorted(asc): " + Utils.arrayToString(StatUtils.sort(array, true)));
        System.out.println("sorted(desc): " + Utils.arrayToString(StatUtils.sort(array, false)));
        System.out.println("min: " + StatUtils.min(array));
        System.out.println("max: " + StatUtils.max(array));
        System.out.println("mean: " + StatUtils.mean(array));
        System.out.println("median: " + StatUtils.median(array));
        System.out.println("stddev (pop.): " + StatUtils.stddev(array, false));
        System.out.println("normalized array: " + Utils.arrayToString(StatUtils.normalize(array)));
        System.out.println("standardized array (pop.): " + Utils.arrayToString(StatUtils.standardize(array, false)));
    }
}

