/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingObject;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionProvider;
import adams.db.SimpleResultSet;
import adams.db.TableManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQL
extends LoggingObject
implements DatabaseConnectionProvider {
    private static final long serialVersionUID = -7708896486343190549L;
    protected boolean m_Debug;
    protected AbstractDatabaseConnection m_DatabaseConnection;
    protected static TableManager<SQL> m_TableManager;
    protected static Logger LOGGER;

    public SQL(AbstractDatabaseConnection dbcon) {
        this.m_DatabaseConnection = dbcon;
        this.updatePrefix();
    }

    protected void updatePrefix() {
        String prefix = this.getClass().getName() + "(" + this.getDatabaseConnection().toStringShort() + "/" + this.getDatabaseConnection().hashCode() + ")";
        this.m_Logger = LoggingHelper.getLogger(prefix);
        this.m_Logger.setLevel(this.getDebug() ? Level.INFO : Level.OFF);
    }

    @Override
    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DatabaseConnection;
    }

    public void setDebug(boolean value) {
        this.m_Debug = value;
        this.getLogger().setLevel(value ? Level.INFO : Level.WARNING);
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String escapeQuotes(String in) {
        String ret = in.replaceAll("'", "\"");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(String table) {
        boolean tableExists = false;
        ResultSet rs = null;
        Connection connection = this.m_DatabaseConnection.getConnection(true);
        try {
            DatabaseMetaData dbmd = connection.getMetaData();
            rs = dbmd.getTables(null, null, table, null);
            tableExists = rs.next();
        }
        catch (SQLException e) {
            try {
                DatabaseMetaData dbmd = connection.getMetaData();
                rs = dbmd.getTables(null, null, table, null);
                tableExists = rs.next();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        catch (Exception e) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
        }
        return tableExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean columnExists(String table, String column) {
        boolean result = false;
        ResultSet rs = null;
        Connection conn = this.m_DatabaseConnection.getConnection(true);
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getColumns(null, null, table, column);
            result = rs.next();
        }
        catch (SQLException e) {
            try {
                DatabaseMetaData dbmd = conn.getMetaData();
                rs = dbmd.getColumns(null, null, table, column);
                result = rs.next();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        catch (Exception e) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public SimpleResultSet getSimpleResultSet(String query) throws Exception {
        return new SimpleResultSet(this.getResultSet(query));
    }

    public PreparedStatement prepareStatement(String query) throws Exception {
        return this.prepareStatement(query, false);
    }

    public PreparedStatement prepareStatement(String query, boolean returnKeys) throws Exception {
        Connection connection = this.m_DatabaseConnection.getConnection(true);
        PreparedStatement stmt = null;
        this.getLogger().info("Preparing statement for: " + query);
        try {
            stmt = returnKeys ? connection.prepareStatement(query, 1) : connection.prepareStatement(query);
        }
        catch (SQLException e) {
            stmt = returnKeys ? connection.prepareStatement(query, 1) : connection.prepareStatement(query);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error preparing statement for: " + query, e);
            throw new Exception(e);
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String updateString, String table, String where) throws Exception {
        String query = "UPDATE " + table + " SET " + updateString + " WHERE " + where;
        Connection connection = this.m_DatabaseConnection.getConnection(true);
        Statement stmt = null;
        this.getLogger().info("Updating: " + query);
        int uc = 0;
        try {
            stmt = connection.createStatement();
            stmt.execute(query);
        }
        catch (SQLException e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                stmt = connection.createStatement();
                stmt.execute(query);
            }
            catch (Exception ex) {
                this.getLogger().log(Level.SEVERE, "Error executing 'update': " + query, ex);
                int n = -1;
                return n;
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to create/execute statement", e);
            int n = -1;
            return n;
        }
        finally {
            if (stmt != null) {
                uc = stmt.getUpdateCount();
                stmt.close();
            }
        }
        return uc;
    }

    public ResultSet executeGeneratedKeys(String query) throws Exception {
        Connection connection = this.m_DatabaseConnection.getConnection(true);
        Statement stmt = null;
        this.getLogger().info("Execute generated keys: " + query);
        try {
            stmt = connection.createStatement();
            stmt.execute(query, 1);
            return stmt.getGeneratedKeys();
        }
        catch (SQLException e) {
            this.getLogger().log(Level.SEVERE, "Error executing 'executeGeneratedKeys': " + query, e);
            if (stmt != null) {
                stmt.close();
            }
            return null;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to generate keys", e);
            if (stmt != null) {
                stmt.close();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean execute(String query) throws Exception {
        Boolean result;
        Connection connection = this.m_DatabaseConnection.getConnection(true);
        if (connection == null) {
            throw new IllegalStateException("Connection object is null (" + this.m_DatabaseConnection.toStringShort() + "/" + this.m_DatabaseConnection.hashCode() + ")!");
        }
        Statement stmt = null;
        this.getLogger().info("Execute: " + query);
        try {
            stmt = connection.createStatement();
            result = stmt.execute(query);
        }
        catch (SQLException e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                stmt = connection.createStatement();
                result = stmt.execute(query);
            }
            catch (Exception ex) {
                this.getLogger().log(Level.SEVERE, "Error executing 'execute': " + query, e);
                result = null;
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error executing query: " + query, e);
            result = null;
        }
        finally {
            SQL.close(stmt);
        }
        return result;
    }

    public boolean truncate(String table) {
        boolean result;
        try {
            this.execute("TRUNCATE TABLE " + table);
            result = true;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error truncating table '" + table + "':", e);
            result = false;
        }
        return result;
    }

    public boolean drop(String table) {
        boolean result;
        try {
            this.execute("DROP TABLE " + table);
            result = true;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error dropping table '" + table + "':", e);
            result = false;
        }
        return result;
    }

    public static boolean isNumeric(int colType) {
        return colType == -5 || colType == -7 || colType == 3 || colType == 8 || colType == 6 || colType == 4 || colType == 2 || colType == 7 || colType == 5 || colType == -6;
    }

    public static boolean isInteger(int colType) {
        return colType == -5 || colType == -7 || colType == 4 || colType == 5 || colType == -6;
    }

    public static boolean isString(int colType) {
        return colType == 1 || colType == 2005 || colType == -16 || colType == -1 || colType == -15 || colType == -9 || colType == 12;
    }

    public static boolean isDate(int colType) {
        return colType == 91 || colType == 92 || colType == 93;
    }

    public static void close(Statement s) {
        if (s != null) {
            try {
                s.close();
                s = null;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error closing statement", e);
            }
        }
    }

    public static void closeAll(ResultSet r) {
        if (r != null) {
            try {
                Statement s = r.getStatement();
                r.close();
                SQL.close(s);
                s = null;
                r = null;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error closing resultset", e);
            }
        }
    }

    public static void closeAll(SimpleResultSet r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error closing resultset/statement", e);
            }
        }
    }

    public ResultSet select(String columns, String tables, String where) throws Exception {
        return this.doSelect(false, columns, tables, where);
    }

    public ResultSet selectDistinct(String columns, String tables, String where) throws Exception {
        return this.doSelect(true, columns, tables, where);
    }

    protected ResultSet doSelect(boolean distinct, String columns, String tables, String where) throws Exception {
        String query = "SELECT ";
        if (distinct) {
            query = query + "DISTINCT ";
        }
        query = query + columns;
        query = query + " FROM " + tables;
        if (where != null && where.length() > 0) {
            if (!where.trim().toUpperCase().startsWith("LIMIT ") && !where.trim().toUpperCase().startsWith("ORDER ")) {
                query = query + " WHERE";
            }
            query = query + " " + where;
        }
        this.getLogger().info("doSelect: " + query);
        try {
            return this.getResultSet(query);
        }
        catch (SQLException e) {
            this.getLogger().log(Level.SEVERE, "Error executing 'doSelect': " + query, e);
            throw e;
        }
    }

    public static int booleanToTinyInt(boolean b) {
        if (b) {
            return 1;
        }
        return 0;
    }

    public static boolean tinyIntToBoolean(int i) {
        return i != 0;
    }

    public static String backquote(BaseRegExp s) {
        return SQL.backquote(s.getValue());
    }

    public static String backquote(String s) {
        String result = Utils.backQuoteChars(s);
        if (!result.startsWith("'")) {
            result = "'" + result + "'";
        }
        return result;
    }

    public ResultSet getResultSet(String query) throws Exception {
        Connection connection = this.m_DatabaseConnection.getConnection(true);
        this.getLogger().info("Get ResultSet for : " + query);
        if (connection == null) {
            throw new IllegalStateException("Connection object is null!");
        }
        Statement stmt = null;
        try {
            stmt = connection.createStatement(1004, 1007);
        }
        catch (SQLException e) {
            stmt = connection.createStatement(1003, 1007);
        }
        return stmt.executeQuery(query);
    }

    public String toString() {
        return "SQL: " + this.getDatabaseConnection().toString();
    }

    public int getMaxColumnNameLength() throws SQLException {
        DatabaseMetaData meta = this.m_DatabaseConnection.getConnection(false).getMetaData();
        int result = meta.getMaxColumnNameLength();
        if (result == 0) {
            result = Integer.MAX_VALUE;
        }
        return result;
    }

    public static int[] getColumnTypes(ResultSet rs) throws SQLException {
        return SQL.getColumnTypes(rs.getMetaData());
    }

    public static int[] getColumnTypes(ResultSetMetaData rs) throws SQLException {
        int[] result = new int[rs.getColumnCount()];
        for (int i = 1; i <= rs.getColumnCount(); ++i) {
            result[i - 1] = rs.getColumnType(i);
        }
        return result;
    }

    public static String[] getColumnNames(ResultSet rs) throws SQLException {
        return SQL.getColumnNames(rs.getMetaData());
    }

    public static String[] getColumnNames(ResultSetMetaData rs) throws SQLException {
        String[] result = new String[rs.getColumnCount()];
        for (int i = 1; i <= rs.getColumnCount(); ++i) {
            result[i - 1] = rs.getColumnLabel(i);
        }
        return result;
    }

    public static synchronized SQL getSingleton(AbstractDatabaseConnection dbcon) {
        if (m_TableManager == null) {
            m_TableManager = new TableManager("SQL", null);
        }
        if (!m_TableManager.has(dbcon)) {
            m_TableManager.add(dbcon, new SQL(dbcon));
        }
        return m_TableManager.get(dbcon);
    }

    static {
        LOGGER = LoggingHelper.getConsoleLogger(SQL.class);
    }
}

