/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;

public class BinaryFile
extends AbstractBooleanCondition {
    private static final long serialVersionUID = -6986050060604039765L;
    protected PlaceholderFile m_File;

    @Override
    public String globalInfo() {
        return "Evaluates to 'true' if the file exists and is a binary file.\nA heuristic is used to determine whether a file is binary, based on the first 1024 bytes.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file", "file", new PlaceholderFile("."));
    }

    public void setFile(PlaceholderFile value) {
        this.m_File = value;
        this.reset();
    }

    public PlaceholderFile getFile() {
        return this.m_File;
    }

    public String fileTipText() {
        return "The file to check whether it is binary.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "file", this.m_File, "file: ");
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp(Actor owner) {
        String result = super.setUp(owner);
        if (result == null && this.m_File == null) {
            result = "No file provided!";
        }
        return result;
    }

    @Override
    protected boolean doEvaluate(Actor owner, Token token) {
        return this.m_File.exists() && !this.m_File.isDirectory() && FileUtils.isBinary(this.m_File);
    }
}

