/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.io.DirectoryLister;
import adams.core.io.PlaceholderDirectory;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;

public class FilesMatch
extends AbstractBooleanCondition {
    private static final long serialVersionUID = -6986050060604039765L;
    protected PlaceholderDirectory m_Directory;
    protected BaseRegExp m_RegExp;

    @Override
    public String globalInfo() {
        return "Evaluates to 'true' if at least one file matches the regular expression in the specified directory.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("directory", "directory", new PlaceholderDirectory("."));
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(".*"));
    }

    public void setDirectory(PlaceholderDirectory value) {
        this.m_Directory = value;
        this.reset();
    }

    public PlaceholderDirectory getDirectory() {
        return this.m_Directory;
    }

    public String directoryTipText() {
        return "The directory to search.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression that the files must match.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "directory", this.m_Directory, "dir: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "regExp", this.m_RegExp, ", regexp: ");
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp(Actor owner) {
        String result = super.setUp(owner);
        if (result == null) {
            if (this.m_Directory == null) {
                result = "No directory provided!";
            } else if (this.m_RegExp == null) {
                result = "No regular expression provided!";
            }
        }
        return result;
    }

    @Override
    protected boolean doEvaluate(Actor owner, Token token) {
        DirectoryLister lister = new DirectoryLister();
        lister.setWatchDir(this.m_Directory);
        lister.setRegExp(this.m_RegExp);
        lister.setListFiles(true);
        lister.setListDirs(false);
        lister.setRecursive(false);
        lister.setMaxItems(1);
        String[] list = lister.list();
        return list.length > 0;
    }
}

