/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.Utils;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;

public class IsNumeric
extends AbstractBooleanCondition {
    private static final long serialVersionUID = 3278345095591806425L;

    @Override
    public String globalInfo() {
        return "Evaluates to 'true' if the payload of the token is a number of a numeric string.";
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Number.class, String.class};
    }

    @Override
    protected boolean doEvaluate(Actor owner, Token token) {
        boolean result = false;
        if (token.getPayload() != null) {
            if (token.getPayload() instanceof Number) {
                result = true;
            } else if (token.getPayload() instanceof String) {
                String s = (String)token.getPayload();
                result = Utils.isDouble(s) || Utils.isLong(s);
            }
        }
        return result;
    }
}

