/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.control.AbstractControlActor;
import adams.flow.control.AbstractDirector;
import adams.flow.control.AtomicExecution;
import adams.flow.control.SequentialDirector;

public abstract class AbstractDirectedControlActor
extends AbstractControlActor
implements AtomicExecution {
    private static final long serialVersionUID = -7471817724012995179L;
    protected AbstractDirector m_Director;
    protected boolean m_FinishBeforeStopping;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finish-before-stopping", "finishBeforeStopping", false);
    }

    @Override
    public void setFinishBeforeStopping(boolean value) {
        this.m_FinishBeforeStopping = value;
        this.reset();
    }

    @Override
    public boolean getFinishBeforeStopping() {
        return this.m_FinishBeforeStopping;
    }

    @Override
    public String finishBeforeStoppingTipText() {
        return "If enabled, actor first finishes processing all data before stopping.";
    }

    protected AbstractDirector newDirector() {
        return new SequentialDirector();
    }

    public AbstractDirector getDirector() {
        return this.m_Director;
    }

    @Override
    protected String updateVariables() {
        if (this.m_Director != null) {
            this.m_Director.stopExecution();
            this.m_Director.cleanUp();
            this.m_Director = null;
        }
        return super.updateVariables();
    }

    @Override
    public String getQuickInfo() {
        if (this.m_FinishBeforeStopping) {
            return "atomic execution";
        }
        return null;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Director = this.newDirector();
            this.m_Director.setControlActor(this);
            this.m_Director.setLoggingLevel(this.getLoggingLevel());
            this.m_Director.updatePrefix();
            if (this.m_PauseStateManager != null) {
                this.m_PauseStateManager.addListener(this.m_Director);
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            result = this.m_Director.execute();
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute director", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopExecution() {
        if (this.m_Director != null) {
            if (this.m_FinishBeforeStopping) {
                while (this.isExecuting()) {
                    AbstractDirectedControlActor abstractDirectedControlActor = this;
                    synchronized (abstractDirectedControlActor) {
                        try {
                            this.wait(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            this.m_Director.stopExecution();
        }
        super.stopExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wrapUp() {
        if (this.m_Director != null) {
            while (!this.m_Director.isFinished()) {
                AbstractDirectedControlActor abstractDirectedControlActor = this;
                synchronized (abstractDirectedControlActor) {
                    try {
                        this.wait(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        if (this.m_Director != null) {
            if (this.m_PauseStateManager != null) {
                this.m_PauseStateManager.removeListener(this.m_Director);
            }
            this.m_Director.cleanUp();
            this.m_Director.setControlActor(null);
            this.m_Director = null;
        }
        super.cleanUp();
    }
}

