/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.VariableName;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.flow.control.AbstractControlActor;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.PropertyHelper;
import adams.flow.core.Token;
import adams.flow.transformer.PassThrough;
import adams.gui.goe.PropertyPath;
import java.util.Hashtable;

public class UpdateProperties
extends AbstractControlActor
implements InputConsumer,
OutputProducer {
    private static final long serialVersionUID = -2286932196386647785L;
    public static final String BACKUP_INPUT = "input";
    public static final String BACKUP_OUTPUT = "output";
    protected transient Token m_InputToken;
    protected transient Token m_OutputToken;
    protected BaseString[] m_Properties;
    protected VariableName[] m_VariableNames;
    protected AbstractActor m_SubActor;
    protected transient PropertyPath.PropertyContainer[] m_Containers;

    @Override
    public String globalInfo() {
        return "Updates the properties of the sub-actor using the values associated with the specfiied variables. The input/output of the actor are the same as the ones of the sub-actor, since this control actor merely functions as wrapper.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("property", "properties", new BaseString[0]);
        this.m_OptionManager.add("variable", "variableNames", new VariableName[0]);
        this.m_OptionManager.add("sub-actor", "subActor", new PassThrough());
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_InputToken = null;
        this.m_OutputToken = null;
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "properties", this.m_Properties.length == 1 ? this.m_Properties[0] : Integer.valueOf(this.m_Properties.length), "props: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "variableNames", this.m_VariableNames.length == 1 ? this.m_VariableNames[0] : Integer.valueOf(this.m_VariableNames.length), ", vars: ");
        return result;
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        if (this.m_OutputToken != null) {
            result.put(BACKUP_OUTPUT, this.m_OutputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            ((InputConsumer)((Object)this.m_SubActor)).input(this.m_InputToken);
            state.remove(BACKUP_INPUT);
        }
        if (state.containsKey(BACKUP_OUTPUT)) {
            this.m_OutputToken = (Token)state.get(BACKUP_OUTPUT);
            state.remove(BACKUP_OUTPUT);
        }
        super.restoreState(state);
    }

    public void setProperties(BaseString[] value) {
        this.m_Properties = value;
        this.m_VariableNames = (VariableName[])Utils.adjustArray(this.m_VariableNames, this.m_Properties.length, new VariableName("unknown"));
        this.reset();
    }

    public BaseString[] getProperties() {
        return this.m_Properties;
    }

    public String propertiesTipText() {
        return "The properties to update with the values associated with the specified values.";
    }

    public void setVariableNames(VariableName[] value) {
        this.m_VariableNames = value;
        this.m_Properties = (BaseString[])Utils.adjustArray(this.m_Properties, this.m_VariableNames.length, new BaseString("subActor.property"));
        this.reset();
    }

    public VariableName[] getVariableNames() {
        return this.m_VariableNames;
    }

    public String variableNamesTipText() {
        return "The names of the variables to update the properties with.";
    }

    protected String checkSubActor(AbstractActor actor) {
        if (!ActorUtils.isTransformer(actor)) {
            return "Not a transformer: " + actor;
        }
        return null;
    }

    public void setSubActor(AbstractActor value) {
        String msg = this.checkSubActor(value);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_SubActor = value;
        this.reset();
        this.updateParent();
    }

    public AbstractActor getSubActor() {
        return this.m_SubActor;
    }

    public String subActorTipText() {
        return "The transformer to update the properties for.";
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public AbstractActor get(int index) {
        if (index == 0) {
            return this.m_SubActor;
        }
        throw new IllegalArgumentException("Illegal index: " + index);
    }

    @Override
    public void set(int index, AbstractActor actor) {
        if (index != 0) {
            throw new IllegalArgumentException("Illegal index: " + index);
        }
        this.setSubActor(actor);
    }

    @Override
    public int indexOf(String actor) {
        if (this.m_SubActor.getName().equals(actor)) {
            return 0;
        }
        return -1;
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(false, ActorExecution.SEQUENTIAL, true);
    }

    @Override
    public Class[] accepts() {
        return ((InputConsumer)((Object)this.m_SubActor)).accepts();
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
        if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
            this.getFlowExecutionListeningSupporter().getFlowExecutionListener().preInput(this.m_SubActor, this.m_InputToken);
        }
        ((InputConsumer)((Object)this.m_SubActor)).input(this.m_InputToken);
        if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
            this.getFlowExecutionListeningSupporter().getFlowExecutionListener().postInput(this.m_SubActor);
        }
    }

    @Override
    public Class[] generates() {
        return ((OutputProducer)((Object)this.m_SubActor)).generates();
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Containers = new PropertyPath.PropertyContainer[this.m_Properties.length];
            for (int i = 0; i < this.m_Properties.length; ++i) {
                this.m_Containers[i] = PropertyPath.find((Object)this.m_SubActor, this.m_Properties[i].getValue());
                if (this.m_Containers[i] == null) {
                    result = "Cannot find property '" + this.m_Properties[i] + "' in sub actor!";
                } else {
                    Class<?> cls = this.m_Containers[i].getReadMethod().getReturnType();
                    if (cls.isArray()) {
                        result = "Property '" + this.m_Properties[i] + "' is an array!";
                    }
                }
                if (result != null) break;
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        for (int i = 0; i < this.m_Properties.length; ++i) {
            try {
                Object value = PropertyHelper.convertVariableValue(this.m_Containers[i], this.getVariables().get(this.m_VariableNames[i].getValue()));
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Updating #" + (i + 1) + ": var=" + this.m_VariableNames[i] + ", value=" + this.getVariables().get(this.m_VariableNames[i].getValue()) + ", class=" + (value == null ? "null" : value.getClass().getName()));
                }
                if (PropertyPath.setValue((Object)this.m_SubActor, this.m_Properties[i].stringValue(), value)) continue;
                throw new IllegalStateException("Property #" + (i + 1) + " could not be updated: " + this.m_Properties[i].stringValue());
            }
            catch (Exception e) {
                result = result == null ? "" : result + "\n";
                result = result + this.handleException("Failed to set property '" + this.m_Properties[i] + "': ", e);
            }
        }
        if (result == null) {
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().preExecute(this.m_SubActor);
            }
            result = this.m_SubActor.execute();
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().postExecute(this.m_SubActor);
            }
        }
        return result;
    }

    @Override
    public String execute() {
        String result = super.execute();
        if (this.m_Skip) {
            this.m_OutputToken = this.m_InputToken;
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return ((OutputProducer)((Object)this.m_SubActor)).hasPendingOutput() || this.m_OutputToken != null;
    }

    @Override
    public Token output() {
        Token result;
        this.m_InputToken = null;
        if (this.m_OutputToken != null) {
            result = this.m_OutputToken;
        } else {
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().preOutput(this.m_SubActor);
            }
            result = ((OutputProducer)((Object)this.m_SubActor)).output();
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().postOutput(this.m_SubActor, result);
            }
        }
        return result;
    }

    @Override
    public void wrapUp() {
        this.m_InputToken = null;
        this.m_OutputToken = null;
        super.wrapUp();
    }
}

