/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control.plotprocessor;

import adams.core.CleanUpHandler;
import adams.core.QuickInfoHelper;
import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.flow.container.SequencePlotterContainer;
import java.util.List;

public abstract class AbstractPlotProcessor
extends AbstractOptionHandler
implements QuickInfoSupporter,
CleanUpHandler {
    private static final long serialVersionUID = 6709551233400282459L;
    protected String m_PlotNameSuffix;
    protected String m_LastError;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("plot-name-suffix", "plotNameSuffix", "");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_LastError = null;
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_LastError = null;
    }

    public void setPlotNameSuffix(String value) {
        this.m_PlotNameSuffix = value;
        this.reset();
    }

    public String getPlotNameSuffix() {
        return this.m_PlotNameSuffix;
    }

    public String plotNameSuffixTipText() {
        return "The suffix for the plot name; if left empty, the plot container automatically becomes an " + (Object)((Object)SequencePlotterContainer.ContentType.OVERLAY) + ".";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "plotNameSuffix", this.m_PlotNameSuffix.isEmpty() ? "" : this.m_PlotNameSuffix);
        result = result == null ? "overlay" : "suffix: " + result;
        return result;
    }

    protected String check(SequencePlotterContainer cont) {
        if (cont == null) {
            return "No plot container provided!";
        }
        return null;
    }

    protected String getPlotName(SequencePlotterContainer cont) {
        String result = (String)cont.getValue("PlotName");
        if (this.m_PlotNameSuffix != null && !this.m_PlotNameSuffix.isEmpty()) {
            result = result + this.m_PlotNameSuffix;
        }
        return result;
    }

    protected SequencePlotterContainer.ContentType getPlotType() {
        if (this.m_PlotNameSuffix != null && !this.m_PlotNameSuffix.isEmpty()) {
            return SequencePlotterContainer.ContentType.PLOT;
        }
        return SequencePlotterContainer.ContentType.OVERLAY;
    }

    protected abstract List<SequencePlotterContainer> doProcess(SequencePlotterContainer var1);

    public List<SequencePlotterContainer> process(SequencePlotterContainer cont) {
        this.m_LastError = this.check(cont);
        if (this.m_LastError == null) {
            return this.doProcess(cont);
        }
        this.getLogger().severe(this.m_LastError);
        return null;
    }

    public boolean hasLastError() {
        return this.m_LastError != null;
    }

    public String getLastError() {
        return this.m_LastError;
    }

    @Override
    public void cleanUp() {
        this.m_LastError = null;
    }
}

