/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.execution;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.flow.core.Actor;
import adams.flow.execution.AbstractTimedFlowExecutionListenerWithTable;
import adams.gui.core.HashtableTableModel;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.table.TableModel;

public class CurrentlyExecuted
extends AbstractTimedFlowExecutionListenerWithTable {
    private static final long serialVersionUID = -6155792276833652477L;
    protected Hashtable<String, String> m_Counts;
    protected transient DateFormat m_DateFormat;

    @Override
    public String globalInfo() {
        return "Shows what actors are currently being executed.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Counts = new Hashtable();
    }

    @Override
    public String updateIntervalTipText() {
        return "The update interval after which the GUI gets refreshed.";
    }

    @Override
    public String getListenerTitle() {
        return "Currently executed";
    }

    @Override
    protected TableModel createTableModel() {
        return new HashtableTableModel((Hashtable)this.m_Counts.clone(), new String[]{"Actor", "Timestamp"});
    }

    @Override
    public void startListening() {
        super.startListening();
        this.m_Counts.clear();
        this.m_DateFormat = DateUtils.getTimestampFormatterMsecs();
    }

    @Override
    public void preExecute(Actor actor) {
        super.postExecute(actor);
        String key = actor.getFullName();
        this.m_Counts.put(key, this.m_DateFormat.format(new Date()));
    }

    @Override
    public void postExecute(Actor actor) {
        super.postExecute(actor);
        String key = actor.getFullName();
        this.m_Counts.remove(key);
        this.incCounter();
    }

    @Override
    public void finishListening() {
        super.finishListening();
        if (this.isLoggingEnabled()) {
            this.getLogger().info(this.m_Counts.toString());
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.m_Counts != null) {
            this.m_Counts.clear();
            this.m_Counts = null;
        }
    }
}

