/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.execution;

import adams.flow.condition.bool.BooleanCondition;
import adams.flow.condition.bool.BooleanConditionSupporter;
import adams.flow.condition.bool.Expression;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.execution.AbstractBreakpoint;

public class PathBreakpoint
extends AbstractBreakpoint
implements BooleanConditionSupporter {
    private static final long serialVersionUID = 3782327753485131754L;
    protected String m_Path;
    protected BooleanCondition m_Condition;

    @Override
    public String globalInfo() {
        return "Triggers when the specified actor path (full path) is encountered during listening.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("path", "path", "");
        this.m_OptionManager.add("condition", "condition", new Expression());
    }

    public void setPath(String value) {
        this.m_Path = value;
        this.reset();
    }

    public String getPath() {
        return this.m_Path;
    }

    public String pathTipText() {
        return "The full actor path to listen for.";
    }

    @Override
    public void setCondition(BooleanCondition value) {
        this.m_Condition = value;
        this.reset();
    }

    @Override
    public BooleanCondition getCondition() {
        return this.m_Condition;
    }

    public String conditionTipText() {
        return "The condition to evaluate; if the condition evaluates to 'true', the execution of the flow is interrupted and the control panel can be used.";
    }

    @Override
    protected boolean evaluatePreInput(Actor actor, Token token) {
        return actor.getFullName().equals(this.m_Path) && this.m_Condition.evaluate(actor, token);
    }

    @Override
    protected boolean evaluatePostInput(Actor actor) {
        return actor.getFullName().equals(this.m_Path) && this.m_Condition.evaluate(actor, null);
    }

    @Override
    protected boolean evaluatePreExecute(Actor actor) {
        return actor.getFullName().equals(this.m_Path) && this.m_Condition.evaluate(actor, null);
    }

    @Override
    protected boolean evaluatePostExecute(Actor actor) {
        return actor.getFullName().equals(this.m_Path) && this.m_Condition.evaluate(actor, null);
    }

    @Override
    protected boolean evaluatePreOutput(Actor actor) {
        return actor.getFullName().equals(this.m_Path) && this.m_Condition.evaluate(actor, null);
    }

    @Override
    protected boolean evaluatePostOutput(Actor actor, Token token) {
        return actor.getFullName().equals(this.m_Path) && this.m_Condition.evaluate(actor, token);
    }
}

