/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractCallableActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.Hashtable;

public class CallableSink
extends AbstractCallableActor
implements InputConsumer {
    private static final long serialVersionUID = 4736661460553985100L;
    public static final String BACKUP_CURRENT = "current";
    protected transient Token m_CurrentInput;

    @Override
    public String globalInfo() {
        return "Lets a callable sink consume the input tokens.";
    }

    @Override
    protected AbstractActor findCallableActor() {
        AbstractActor result = super.findCallableActor();
        if (result != null && !ActorUtils.isSink(result)) {
            this.getLogger().severe("Callable actor '" + result.getFullName() + "' is not a sink" + (this.m_CallableActor == null ? "!" : this.m_CallableActor.getClass().getName()));
            result = null;
        }
        return result;
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_CurrentInput != null) {
            result.put(BACKUP_CURRENT, this.m_CurrentInput);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CURRENT)) {
            this.m_CurrentInput = (Token)state.get(BACKUP_CURRENT);
            state.remove(BACKUP_CURRENT);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_CurrentInput = null;
    }

    @Override
    public Class[] accepts() {
        if (this.m_CallableActor != null) {
            return ((InputConsumer)((Object)this.m_CallableActor)).accepts();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        this.m_CurrentInput = token;
    }

    @Override
    protected String executeCallableActor() {
        ((InputConsumer)((Object)this.m_CallableActor)).input(this.m_CurrentInput);
        String result = this.m_CallableActor.execute();
        return result;
    }
}

