/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.sequenceplotter;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequenceUtils;
import adams.flow.sink.sequenceplotter.ErrorCrossPaintlet;
import adams.gui.visualization.container.VisibilityContainer;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;

public class ErrorCrossHitDetector
extends AbstractXYSequencePointHitDetector {
    private static final long serialVersionUID = -3363546923840405674L;

    public ErrorCrossHitDetector(XYSequencePaintlet owner) {
        super(owner);
        this.m_MinimumPixelDifference = 1;
    }

    @Override
    protected Object isHit(MouseEvent e) {
        if (this.m_Owner == null) {
            return null;
        }
        Vector<XYSequencePoint> result = new Vector<XYSequencePoint>();
        AxisPanel axisBottom = this.m_Owner.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisLeft = this.m_Owner.getPlot().getAxis(Axis.LEFT);
        double y = axisLeft.posToValue(e.getY());
        double x = axisBottom.posToValue(e.getX());
        ErrorCrossPaintlet paintlet = null;
        if (this.m_Owner instanceof ErrorCrossPaintlet) {
            paintlet = (ErrorCrossPaintlet)this.m_Owner;
        }
        boolean logging = this.isLoggingEnabled();
        for (int i = 0; i < ((XYSequenceContainerManager)this.m_Owner.getSequencePanel().getContainerManager()).count(); ++i) {
            int index;
            if (!((VisibilityContainer)((XYSequenceContainerManager)this.m_Owner.getSequencePanel().getContainerManager()).get(i)).isVisible()) continue;
            XYSequence s = ((XYSequenceContainer)((XYSequenceContainerManager)this.m_Owner.getSequencePanel().getContainerManager()).get(i)).getData();
            List<XYSequencePoint> points = s.toList();
            if (logging) {
                this.getLogger().info("\n" + s.getID() + ":");
            }
            if ((index = XYSequenceUtils.findClosestX(points, x)) == -1) continue;
            XYSequencePoint sp = points.get(index);
            int diameter = paintlet != null ? paintlet.getDiameter(axisBottom, axisLeft, sp) : 1;
            double diffX = sp.getX() - x;
            double diffPixel = Math.abs(axisBottom.valueToPos(diffX) - axisBottom.valueToPos(0.0));
            if (logging) {
                this.getLogger().info("diff x=" + diffPixel);
            }
            if (diffPixel > (double)(this.m_MinimumPixelDifference + diameter / 2)) continue;
            double diffY = sp.getY() - y;
            diffPixel = Math.abs(axisLeft.valueToPos(diffY) - axisLeft.valueToPos(0.0));
            if (logging) {
                this.getLogger().info("diff y=" + diffPixel);
            }
            if (diffPixel > (double)(this.m_MinimumPixelDifference + diameter / 2)) continue;
            if (logging) {
                this.getLogger().info("hit!");
            }
            result.add(sp);
        }
        if (result.size() > 0) {
            return result;
        }
        return null;
    }
}

