/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUser;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.source.AbstractSource;
import java.lang.reflect.Array;

public class StorageValuesArray
extends AbstractSource
implements StorageUser {
    private static final long serialVersionUID = 8955342876774562591L;
    protected StorageName[] m_StorageNames;
    protected String m_ArrayClass;
    protected Object m_StoredValue;

    @Override
    public String globalInfo() {
        return "Outputs the values associated with the specified names from temporary storage as an array.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageNames", new StorageName[0]);
        this.m_OptionManager.add("array-class", "arrayClass", "");
    }

    public void setStorageNames(StorageName[] value) {
        this.m_StorageNames = value;
        this.reset();
    }

    public StorageName[] getStorageNames() {
        return this.m_StorageNames;
    }

    public String storageNamesTipText() {
        return "The names of the stored values to retrieve as array.";
    }

    public void setArrayClass(String value) {
        this.m_ArrayClass = value;
        this.reset();
    }

    public String getArrayClass() {
        return this.m_ArrayClass;
    }

    public String arrayClassTipText() {
        return "The class to use for the array; if none is specified, the class of the first storage item is used.";
    }

    @Override
    public boolean isUsingStorage() {
        return !this.getSkip() && this.m_StorageNames.length > 0;
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "storageNames", Utils.flatten(this.m_StorageNames, ", "), "Names: ");
        if (result == null) {
            result = "-no names specified-";
        }
        result = result + QuickInfoHelper.toString((OptionHandler)this, "arrayClass", this.m_ArrayClass.length() != 0 ? this.m_ArrayClass : "-from 1st storage item-", ", Class: ");
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_StoredValue = null;
    }

    @Override
    protected String performSetUpChecks(boolean fromSetUp) {
        String result = super.performSetUpChecks(fromSetUp);
        if (result == null && this.canPerformSetUpCheck(fromSetUp, "storageNames") && (this.m_StorageNames == null || this.m_StorageNames.length == 0)) {
            result = "No names specified for storage values!";
        }
        return result;
    }

    @Override
    protected String doExecute() {
        int i;
        String result = null;
        Object[] values = new Object[this.m_StorageNames.length];
        for (i = 0; i < this.m_StorageNames.length; ++i) {
            if (this.getStorageHandler().getStorage().has(this.m_StorageNames[i])) {
                values[i] = this.getStorageHandler().getStorage().get(this.m_StorageNames[i]);
            } else {
                result = "Storage item #" + (i + 1) + " (" + this.m_StorageNames[i] + ") not found!";
            }
            if (result != null) break;
        }
        if (result == null) {
            try {
                this.m_StoredValue = this.m_ArrayClass.trim().length() == 0 ? Array.newInstance(values[0].getClass(), values.length) : Utils.newArray(this.m_ArrayClass, values.length);
                for (i = 0; i < values.length; ++i) {
                    Array.set(this.m_StoredValue, i, values[i]);
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to generate array:", e);
            }
        }
        return result;
    }

    @Override
    public Token output() {
        Token result = new Token(this.m_StoredValue);
        this.m_StoredValue = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_StoredValue != null;
    }
}

