/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.Variables;
import adams.core.io.FlowFile;
import adams.core.option.OptionHandler;
import adams.event.VariableChangeEvent;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import java.util.ArrayList;

public class ExternalFlow
extends AbstractActor {
    private static final long serialVersionUID = 6212392783858480058L;
    protected FlowFile m_FlowFile;
    protected boolean m_ImmediateCleanUp;
    protected AbstractActor m_ExternalFlow;
    protected Boolean m_FlowFileIsVariable;
    protected String m_FlowFileVariable;
    protected boolean m_FlowFileChanged;

    @Override
    public String globalInfo() {
        return "Allows to execute a complete external Flow rather than just an external actor.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file", "flowFile", new FlowFile("."));
        this.m_OptionManager.add("immediate-clean-up", "immediateCleanUp", false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "flowFile", this.m_FlowFile, "file: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "immediateCleanUp", this.m_ImmediateCleanUp, "clean-up", ", ");
        return result;
    }

    public void setFlowFile(FlowFile value) {
        this.m_FlowFile = value;
        this.reset();
    }

    public FlowFile getFlowFile() {
        return this.m_FlowFile;
    }

    public String flowFileTipText() {
        return "The file containing the external flow.";
    }

    public void setImmediateCleanUp(boolean value) {
        this.m_ImmediateCleanUp = value;
        this.reset();
    }

    public boolean getImmediateCleanUp() {
        return this.m_ImmediateCleanUp;
    }

    public String immediateCleanUpTipText() {
        return "If enabled, the flow gets immediately cleaned up after execution, ie removing graphical output.";
    }

    @Override
    public synchronized void setVariables(Variables value) {
    }

    @Override
    protected void forceVariables(Variables value) {
    }

    @Override
    public void variableChanged(VariableChangeEvent e) {
        super.variableChanged(e);
        if (this.m_FlowFileIsVariable == null) {
            this.m_FlowFileVariable = this.getOptionManager().getVariableForProperty("flowFile");
            this.m_FlowFileIsVariable = this.m_FlowFileVariable != null;
            if (this.m_FlowFileIsVariable.booleanValue()) {
                this.m_FlowFileVariable = Variables.extractName(this.m_FlowFileVariable);
            }
        }
        if (this.m_FlowFileIsVariable.booleanValue() && e.getName().equals(this.m_FlowFileVariable)) {
            this.m_FlowFileChanged = e.getType() != VariableChangeEvent.Type.REMOVED;
        }
    }

    public String setUpExternalActor() {
        String result = null;
        if (!this.m_FlowFile.isFile()) {
            result = "'" + this.m_FlowFile.getAbsolutePath() + "' does not point to a file!";
        } else {
            ArrayList<String> errors = new ArrayList<String>();
            this.m_ExternalFlow = ActorUtils.read(this.m_FlowFile.getAbsolutePath(), errors);
            if (!errors.isEmpty()) {
                result = "Error loading external flow '" + this.m_FlowFile.getAbsolutePath() + "':\n" + Utils.flatten(errors, "\n");
            } else if (this.m_ExternalFlow == null) {
                result = "Error loading external flow '" + this.m_FlowFile.getAbsolutePath() + "'!";
            } else {
                this.m_ExternalFlow.setHeadless(this.isHeadless());
                this.m_ExternalFlow = ActorUtils.removeDisabledActors(this.m_ExternalFlow);
                result = this.m_ExternalFlow.setUp();
            }
        }
        this.m_FlowFileChanged = false;
        return result;
    }

    public void cleanUpExternalActor() {
        if (this.m_FlowFileChanged && this.m_ExternalFlow != null) {
            this.m_ExternalFlow.wrapUp();
            this.m_ExternalFlow.cleanUp();
            this.m_ExternalFlow = null;
        }
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.cleanUpExternalActor();
            if (this.getOptionManager().getVariableForProperty("flowFile") == null && this.m_ExternalFlow == null) {
                result = this.setUpExternalActor();
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        this.cleanUpExternalActor();
        if (this.m_ExternalFlow == null) {
            result = this.setUpExternalActor();
        }
        if (result == null) {
            result = this.m_ExternalFlow.execute();
            if (this.m_ImmediateCleanUp) {
                this.m_ExternalFlow.wrapUp();
                this.m_ExternalFlow.destroy();
                this.m_ExternalFlow = null;
            }
        }
        return result;
    }

    @Override
    public void stopExecution() {
        super.stopExecution();
        if (this.m_ExternalFlow != null) {
            this.m_ExternalFlow.stopExecution();
        }
    }

    @Override
    public void wrapUp() {
        if (this.m_ExternalFlow != null && !this.m_ImmediateCleanUp) {
            this.m_ExternalFlow.wrapUp();
        }
        this.m_FlowFileIsVariable = null;
        this.m_FlowFileVariable = null;
        this.m_FlowFileChanged = false;
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        if (this.m_ExternalFlow != null) {
            this.m_ExternalFlow.destroy();
            this.m_ExternalFlow = null;
        }
        super.cleanUp();
    }
}

