/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.SystemInfo;
import adams.core.Utils;
import adams.core.base.BaseString;
import adams.core.management.ClassPathAugmenter;
import adams.core.management.Launcher;
import adams.core.management.LoggingObjectOutputPrinter;
import adams.core.management.RecordingOutputPrinter;
import adams.core.option.OptionHandler;
import adams.flow.control.AbstractControlActor;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.FixedNameActorHandler;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import adams.flow.sink.Null;

public class JavaExec
extends AbstractControlActor
implements FixedNameActorHandler {
    private static final long serialVersionUID = -6073217549744299278L;
    public static final String NAME_STDOUT = "stdout";
    public static final String NAME_STDERR = "stderr";
    protected String m_JavaClass;
    protected String m_Memory;
    protected BaseString[] m_JVM;
    protected BaseString[] m_Options;
    protected ClassPathAugmenter[] m_ClassPathAugmenters;
    protected boolean m_RecordOutput;
    protected AbstractActor m_StdOut;
    protected AbstractActor m_StdErr;

    @Override
    public String globalInfo() {
        return "Forks off a new JVM with the same classpath by default. The classpath can be extended using classpath augmenters. Additional JVM options can be supplied as well, apart from the heap size.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("java-class", "javaClass", SystemInfo.class.getName());
        this.m_OptionManager.add("memory", "memory", "256m");
        this.m_OptionManager.add("jvm", "JVM", new BaseString[0]);
        this.m_OptionManager.add("option", "options", new BaseString[0]);
        this.m_OptionManager.add("classpath-augmenter", "classPathAugmenters", new ClassPathAugmenter[0]);
        this.m_OptionManager.add("record-output", "recordOutput", false);
        this.m_OptionManager.add(NAME_STDOUT, "stdOut", new Null());
        this.m_OptionManager.add(NAME_STDERR, "stdErr", new Null());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_StdOut = new Null();
        this.m_StdErr = new Null();
    }

    public void setJavaClass(String value) {
        this.m_JavaClass = value;
        this.reset();
    }

    public String getJavaClass() {
        return this.m_JavaClass;
    }

    public String javaClassTipText() {
        return "The java class to execute.";
    }

    public void setMemory(String value) {
        this.m_Memory = value;
        this.reset();
    }

    public String getMemory() {
        return this.m_Memory;
    }

    public String memoryTipText() {
        return "The amount of memory to start the JVM with.";
    }

    public void setJVM(BaseString[] value) {
        this.m_JVM = value;
        this.reset();
    }

    public BaseString[] getJVM() {
        return this.m_JVM;
    }

    public String JVMTipText() {
        return "The additional options for the JVM.";
    }

    public void setOptions(BaseString[] value) {
        this.m_Options = value;
        this.reset();
    }

    public BaseString[] getOptions() {
        return this.m_Options;
    }

    public String optionsTipText() {
        return "The options for the Java class.";
    }

    public void setClassPathAugmenters(ClassPathAugmenter[] value) {
        this.m_ClassPathAugmenters = value;
        this.reset();
    }

    public ClassPathAugmenter[] getClassPathAugmenters() {
        return this.m_ClassPathAugmenters;
    }

    public String classPathAugmentersTipText() {
        return "The classpath augmenters to use when launching the Java process.";
    }

    public void setRecordOutput(boolean value) {
        this.m_RecordOutput = value;
        this.reset();
    }

    public boolean getRecordOutput() {
        return this.m_RecordOutput;
    }

    public String recordOutputTipText() {
        return "If enabled, the output of stdout/stderr gets recorded and forwarded (as string) to the appropriate sub-actor for further processing.";
    }

    public void setStdOut(AbstractActor value) {
        if (value instanceof InputConsumer) {
            this.m_StdOut = value;
            this.m_StdOut.setName(NAME_STDOUT);
            this.updateParent();
            this.reset();
        } else {
            this.getLogger().severe("stdout actor must consume input, " + value.getClass().getName() + " doesn't!");
        }
    }

    public AbstractActor getStdOut() {
        return this.m_StdOut;
    }

    public String stdOutTipText() {
        return "The actor for further processing the stdout output (string).";
    }

    public void setStdErr(AbstractActor value) {
        if (value instanceof InputConsumer) {
            this.m_StdErr = value;
            this.m_StdErr.setName(NAME_STDERR);
            this.updateParent();
            this.reset();
        } else {
            this.getLogger().severe("stderr actor must consume input, " + value.getClass().getName() + " doesn't!");
        }
    }

    public AbstractActor getStdErr() {
        return this.m_StdErr;
    }

    public String stdErrTipText() {
        return "The actor for further processing the stderr output (string).";
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(false, false, ActorExecution.PARALLEL, true, new Class[]{InputConsumer.class}, false);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public AbstractActor get(int index) {
        if (index == 0) {
            return this.m_StdOut;
        }
        if (index == 1) {
            return this.m_StdErr;
        }
        throw new IllegalArgumentException("Invalid index: " + index);
    }

    @Override
    public void set(int index, AbstractActor actor) {
        if (index == 0) {
            this.setStdOut(actor);
        } else if (index == 1) {
            this.setStdErr(actor);
        } else {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
    }

    @Override
    public int indexOf(String actor) {
        if (this.m_StdOut.getName().equals(actor)) {
            return 0;
        }
        if (this.m_StdErr.getName().equals(actor)) {
            return 1;
        }
        return -1;
    }

    @Override
    public String getFixedName(int index) {
        if (index == 0) {
            return NAME_STDOUT;
        }
        if (index == 1) {
            return NAME_STDERR;
        }
        throw new IllegalArgumentException("Invalid index: " + index);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "javaClass", this.m_JavaClass);
        String value = QuickInfoHelper.toString((OptionHandler)this, "memory", this.m_Memory, " -Xmx");
        if (value != null) {
            result = result + value;
        }
        if ((value = QuickInfoHelper.toString((OptionHandler)this, "JVM", Utils.flatten(this.m_JVM, " "), " ")) != null) {
            result = result + value;
        }
        if ((value = QuickInfoHelper.toString((OptionHandler)this, "options", Utils.flatten(this.m_Options, " "), " ")) != null) {
            result = result + value;
        }
        if ((value = QuickInfoHelper.toString((OptionHandler)this, "recordOutput", this.m_RecordOutput, "record output", ", ")) != null) {
            result = result + value;
        }
        return result;
    }

    @Override
    protected String doExecute() {
        Launcher launcher = new Launcher();
        launcher.ignoreEnvironmentOptions();
        launcher.suppressErrorDialog();
        launcher.setMainClass(this.m_JavaClass);
        launcher.setMemory(this.m_Memory);
        for (BaseString opt : this.m_JVM) {
            launcher.addJVMOption(opt.getValue());
        }
        for (ClassPathAugmenter cpa : this.m_ClassPathAugmenters) {
            launcher.addClassPathAugmentations(cpa);
        }
        String[] options = new String[this.m_Options.length];
        for (int i = 0; i < this.m_Options.length; ++i) {
            options[i] = this.m_Options[i].getValue();
        }
        launcher.setArguments(options);
        launcher.setConsoleObject(this);
        if (this.m_RecordOutput) {
            launcher.setOutputPrinter(RecordingOutputPrinter.class);
        } else {
            launcher.setOutputPrinter(LoggingObjectOutputPrinter.class);
        }
        String result = launcher.execute();
        if (this.m_RecordOutput) {
            Token input;
            if (result == null) {
                try {
                    input = new Token(((RecordingOutputPrinter)launcher.getStdOut().getPrinter()).getRecording());
                    ((InputConsumer)((Object)this.m_StdOut)).input(input);
                    result = this.m_StdOut.execute();
                }
                catch (Exception e) {
                    result = this.handleException("Failed to process data with stdout sub-actor!", e);
                }
            }
            if (result == null) {
                try {
                    input = new Token(((RecordingOutputPrinter)launcher.getStdErr().getPrinter()).getRecording());
                    ((InputConsumer)((Object)this.m_StdErr)).input(input);
                    result = this.m_StdErr.execute();
                }
                catch (Exception e) {
                    result = this.handleException("Failed to process data with stderr sub-actor!", e);
                }
            }
        }
        return result;
    }
}

