/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.VariableName;
import adams.core.VariableUpdater;
import adams.core.option.OptionHandler;
import adams.flow.standalone.AbstractStandalone;
import java.util.ArrayList;

public class SetVariable
extends AbstractStandalone
implements VariableUpdater {
    private static final long serialVersionUID = -3383735680425581504L;
    protected VariableName m_VariableName;
    protected String m_VariableValue;
    protected boolean m_ExpandValue;

    @Override
    public String globalInfo() {
        return "Sets the value of a variable.\nOptionally, the specified value (or incoming value) can be expanded, in case it is made up of variables itself.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("var-name", "variableName", new VariableName());
        this.m_OptionManager.add("var-value", "variableValue", "value");
        this.m_OptionManager.add("expand-value", "expandValue", false);
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The name of the variable to update.";
    }

    public void setVariableValue(String value) {
        this.m_VariableValue = value;
        this.reset();
    }

    public String getVariableValue() {
        return this.m_VariableValue;
    }

    public String variableValueTipText() {
        return "The value for the variable to use.";
    }

    public void setExpandValue(boolean value) {
        this.m_ExpandValue = value;
        this.reset();
    }

    public boolean getExpandValue() {
        return this.m_ExpandValue;
    }

    public String expandValueTipText() {
        return "If enabled, the value gets expanded first in case it is made up of variables itself.";
    }

    @Override
    public boolean isUpdatingVariables() {
        return !this.getSkip();
    }

    @Override
    public String getQuickInfo() {
        String variable = QuickInfoHelper.getVariable(this, "variableName");
        String result = variable != null ? variable : this.m_VariableName.paddedValue();
        String value = QuickInfoHelper.toString((OptionHandler)this, "variableValue", this.m_VariableValue, " = ");
        if (value != null) {
            result = result + value;
        }
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "expandValue", this.m_ExpandValue, "expand"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        String value = this.m_VariableValue;
        if (this.m_ExpandValue) {
            value = this.getVariables().expand(value);
        }
        this.getVariables().set(this.m_VariableName.getValue(), value);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Setting variable '" + this.m_VariableName + "': " + value);
        }
        return result;
    }
}

