/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.db.AbstractDatabaseConnection;
import adams.db.AbstractTableCleanUp;
import adams.db.SQLTableCleanUp;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.AbstractStandalone;
import adams.flow.standalone.DatabaseConnection;

public class TableCleanUp
extends AbstractStandalone {
    private static final long serialVersionUID = -295054877801672294L;
    protected AbstractTableCleanUp m_Cleaner;

    @Override
    public String globalInfo() {
        return "Runs a table cleaner.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cleaner", "cleaner", new SQLTableCleanUp());
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "cleaner", this.m_Cleaner);
    }

    public void setCleaner(AbstractTableCleanUp value) {
        this.m_Cleaner = value;
        this.reset();
    }

    public AbstractTableCleanUp getCleaner() {
        return this.m_Cleaner;
    }

    public String cleanerTipText() {
        return "The table cleaner to run.";
    }

    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return adams.db.DatabaseConnection.getSingleton();
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection(this, DatabaseConnection.class, this.getDefaultDatabaseConnection());
    }

    @Override
    protected String doExecute() {
        String result;
        try {
            this.m_Cleaner.setDatabaseConnection(this.getDatabaseConnection());
            result = this.m_Cleaner.cleanUpTable();
        }
        catch (Exception e) {
            result = this.handleException("Failed to clean up table: " + this.m_Cleaner, e);
        }
        return result;
    }
}

