/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.lang.reflect.Array;

public class ArrayLength
extends AbstractTransformer {
    private static final long serialVersionUID = -2381609485309053125L;

    @Override
    public String globalInfo() {
        return "Determines the length of an array.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Integer.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            Object array = this.m_InputToken.getPayload();
            this.m_OutputToken = new Token(Array.getLength(array));
        }
        catch (Exception e) {
            result = this.handleException("Failed to determine array length: ", e);
        }
        return result;
    }
}

