/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;

public class CollectionToSequence
extends AbstractTransformer {
    private static final long serialVersionUID = -8967664394563844948L;
    public static final String BACKUP_ELEMENTS = "elements";
    protected List m_Elements;

    @Override
    public String globalInfo() {
        return "Turns a collection of any type into a sequence of tokens.";
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_ELEMENTS);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_ELEMENTS, this.m_Elements);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_ELEMENTS)) {
            this.m_Elements = (List)state.get(BACKUP_ELEMENTS);
            state.remove(BACKUP_ELEMENTS);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Elements = new ArrayList();
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Collection.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Token output() {
        Token result = new Token(this.m_Elements.get(0));
        this.m_Elements.remove(0);
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Elements.size() > 0;
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            this.m_Elements.clear();
            this.m_Elements.addAll((Collection)this.m_InputToken.getPayload());
        }
        catch (Exception e) {
            result = this.handleException("Failed to turn collection into sequence: ", e);
        }
        return result;
    }
}

